#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import cPickle as pk
import json
from kubernetes.client.api_client import ApiClient


class CommonUtils(object):

    def __init__(self):
        pass

    @staticmethod
    def remove_none_keys(dictionary):
        return {k: v for k, v in dictionary.iteritems() if v is not None}

    @staticmethod
    def convert_to_int_if_possible(str_var):
        return_value = str_var
        try:
            return_value = int(str_var)
        except ValueError:
            pass
        return return_value

    @staticmethod
    def get_properties_dict(properties):
        vol_prop = {}
        for key, val in properties.items():
            vol_prop[key] = True if val.lower() == 'true' else pk.loads(pk.dumps(val))
        return vol_prop

    @staticmethod
    def print_request_dump(container, request, kind, api_version):
        if container.debug:
            request_dict = request if type(request) is dict else ApiClient().sanitize_for_serialization(request)
            request_dict["kind"] = kind
            request_dict["apiVersion"] = api_version
            print "\nThe request dump as json: "
            print json.dumps(request_dict, indent=2, separators=(',', ': '))
            print "------\n\n"

    @staticmethod
    def print_response_dump(container, response):
        if container.debug:
            print("\nThe response dump: {}".format(response))
            print "------\n\n"

    @staticmethod
    def get_kind(class_type):
        class_name = class_type.__class__.__name__
        return class_name[:-7]
