cis_to_create_list = []
constructed_cis_list = []
constructed_cis_list_individually = []
packages_to_import = []
tasks_to_create = []
tasks_to_update = []
tasks_to_start = []
updated_tasks_to_start = []
cis_to_update = []
cis_to_move_list = []
cis_to_grant_permissions = []
users_to_create = []
roles_to_assign = []
tasks_to_archive = []


def assign_role(role_name, principals=[]):
    roles_to_assign.append((role_name, principals))


def create_ci(id, type, properties=[], file = False, file_name = False):
    cis_to_create_list.append((id, type, properties, file, file_name))


def move_ci(id, type, properties=[]):
    cis_to_move_list.append((id, type, properties))


def create_user(username, password):
    users_to_create.append((username, password))


def update_ci(id, func):
    cis_to_update.append((id, func))


def create_initial_task(app_id, env_id, user_name='admin', run=True, archive=False):
    tasks_to_create.append(('initial', app_id, env_id, user_name, run, archive))


def upgrade_task(app_id, env_id, user_name='admin', run=True, archive=False):
    tasks_to_update.append(('upgrade', app_id, env_id, user_name, run, archive))


def create_control_task(app_id, command_name, run=True, archive=False):
    tasks_to_create.append(('control', app_id, command_name, run, archive))


def grant_permissions(permission, role_name, ci_ids=[]):
    cis_to_grant_permissions.append((permission, role_name, ci_ids))


def schedule_initial_task(app_id, env_id, time):
    tasks_to_create.append(('schedule', app_id, env_id, time))


def import_package(package_name):
    packages_to_import.append(package_name)


def bulk_construct_cis():
    for ci_to_create in cis_to_create_list:
        if ci_to_create[4]:
            artifact = factory.artifact(ci_to_create[0], ci_to_create[1], ci_to_create[2], ci_to_create[3])
            artifact.filename = ci_to_create[4]
            constructed_cis_list_individually.append(artifact)
        elif ci_to_create[2]:
            constructed_cis_list.append(factory.configurationItem(ci_to_create[0], ci_to_create[1], ci_to_create[2]))
        else:
            constructed_cis_list.append(factory.configurationItem(ci_to_create[0], ci_to_create[1]))


def bulk_cis_move():
    for ci_to_move in cis_to_move_list:
        repository.move(ci_to_move[0], ci_to_move[1])


def bulk_cis_creation():
    print "Creating CIs"
    bulk_construct_cis()
    repository.create(constructed_cis_list)

    # limitation in XLD, can't find proper converter for ArtifactAndData if to provide the collection of CIs
    for ci_to_create in constructed_cis_list_individually:
        repository.create(ci_to_create)


def bulk_import_packages():
    print "Importing packages"
    for package_to_import in packages_to_import:
        deployit.importPackage(package_to_import)


def bulk_cis_update():
    print "Updating CIs"
    for ci_to_update in cis_to_update:
        ci_id = ci_to_update[0]
        applyChanges = ci_to_update[1]

        ci = repository.read(ci_id)
        applyChanges(ci)
        repository.update(ci)


def bulk_create_tasks():
    print "Creating tasks"

    for task_to_create in tasks_to_create:
        task_type = task_to_create[0]
        if task_type == 'initial':
            task_id = create_initial_deployment(task_to_create)
            if task_to_create[5]:
                tasks_to_archive.append(task_id)
        elif task_type == 'control':
            task_id = create_control_task_deployment(task_to_create)
            if task_to_create[4]:
                tasks_to_archive.append(task_id)
        elif task_type == 'schedule':
            schedule_initial_deployment(task_to_create)
        else:
            raise Exception('Not supported task type ', task_type)

    bulk_start_tasks()


def bulk_update_tasks():
    print "Updating tasks"

    for task_to_update in tasks_to_update:
        create_update_deployment(task_to_update)

    bulk_updated_tasks_to_start()


def chunks(l, n):
    for i in range(0, len(l), n):
        yield l[i:i + n]


def _run_tasks(task_ids):
    chunk_num = 10
    total = len(task_ids)
    left_to_process = total
    for chuck_of_task_ids in list(chunks(task_ids, chunk_num)):
        for task_id in chuck_of_task_ids:
            task2.start(task_id)
        wait_till_no_active_tasks_left()
        left_to_process -= len(chuck_of_task_ids)
        print "Left to process % s out of %s" % (left_to_process, total)


def bulk_start_tasks():
    print "Starting the tasks (%s tasks)" % len(tasks_to_start)
    _run_tasks(tasks_to_start)


def bulk_updated_tasks_to_start():
    print "Starting to upgrade deployments (%s tasks)" % len(updated_tasks_to_start)
    _run_tasks(updated_tasks_to_start)


def bulk_grant_permission():
    print "Granting permissions"
    for ci_to_grant_permissions in cis_to_grant_permissions:
        permission = ci_to_grant_permissions[0]
        role_name = ci_to_grant_permissions[1]
        ci_ids = ci_to_grant_permissions[2]

        if ci_ids:
            security.grant(permission, role_name, ci_ids)
        else:
            security.grant(permission, role_name)


def bulk_create_users():
    print "Creating users"
    for user_to_create in users_to_create:
        security.createUser(user_to_create[0], user_to_create[1])


def bulk_roles_to_assign():
    print "Assigning roles"
    for role_to_assign in roles_to_assign:
        security.assignRole(role_to_assign[0], role_to_assign[1])


def bulk_tasks_archive():
    for task_to_archive in tasks_to_archive:
        task2.archive(task_to_archive)


def create_default_ssh_host(ci_id):
    create_ci(ci_id, 'overthere.SshHost', {
        'address': 'localhost',
        'connectionType': 'SUDO',
        'os': 'UNIX',
        'password': 'root',
        'port': '12345',
        'sudoUsername': 'root',
        'username': 'root'
    })
