#!/bin/bash
DESTINATION=$(dirname "$0")
read -r -d '' ruleDocumentStart << ETX
kind: Rules
metadata:
  namespace: large-source
spec:
ETX

echo "$ruleDocumentStart" > "$DESTINATION/stitch-rules.yaml"

for i in {0..100}
do
  read -r -d '' ruleContent << ETXX
  - name: "rule-$i"
    condition:
      deployedType: yak.Json
    processor:
      - type: freemarker
        description: "Prints source file"
        parameters:
          template: |
            { "metadata" : {
                  "labels": {
                      "mylabel": "\${myValue}",
                      "application": "\${application}",
                      "environment": "\${environment}",
                      "envNameFromContext": "\${ctx.deployedApplication.environment.name}"
                  }
                }
             }
          variables:
            myValue: value-$i
            application: "#{#ctx.deployedApplication.id}"
            environment: "#{#ctx.deployedApplication.environment.name}"
ETXX
printf "  %s\n" "$ruleContent" >> "$DESTINATION/stitch-rules.yaml"
done

for i in {101..200}
do
read -r -d '' anotherRule << ETXX
---
kind: Rules
metadata:
  namespace: large-source
spec:
  - name: "another-rule-$i"
    condition:
      deployedType: yak.Json
    processor:
      - type: freemarker
        description: "Prints source file"
        weight: $i
        merge:
         type: overlay
        parameters:
          template: |
            { "metadata" : {
                  "labels": {
                      "mylabel": "\${myValue}",
                      "application": "\${application}",
                      "environment": "\${environment}",
                  }
                }
             }
          variables:
            myValue: value-$i
            application: app-$i
            environment: env-$i
---
kind: Macros
metadata:
  namespace: large-source
spec:
  - name: "another-macro-$i"
    description: This is macro-$i for adding labels
    parameters:
      application: undefined
      environment: undefined
    processor:
      - type: freemarker
        description: "Adding app and env label to kubernetes spec"
        parameters:
          template: |
             { "metadata" : {
                  "labels": {
                      "application": "\${application}",
                      "environment": "\${environment}",
                  }
                }
              }
          variables:
            application: $i
            environment: $i
ETXX
printf "%s\n" "$anotherRule" >> "$DESTINATION/stitch-rules.yaml"
done
