from java.nio.file import Paths


def get_bytes_from_file(filename):
    return open(filename, "rb").read()

repository.create(factory.configurationItem('Configuration/StitchFolder', 'stitch.FolderSource', {'path': 'stitch'}))

create_ci('Infrastructure/BankServer', 'yak.YakServer')

create_ci('Environments/Production', 'udm.Environment', {'members': ['Infrastructure/BankServer']})

create_ci('Applications/XLBankApp', 'udm.Application')
create_ci('Applications/XLBankApp/1.0', 'udm.DeploymentPackage')
create_ci('Applications/XLBankApp/1.0/MobileBankingResource',
          'yak.StitchFileResourceFile',
          {'ruleNamespace': 'xl-bank', 'ruleName': 'xl-bank-labels'},
          get_bytes_from_file(Paths.get(__file__).toAbsolutePath().getParent().getParent()
                              .resolve("src")
                              .resolve("main")
                              .resolve("resources")
                              .resolve("xld")
                              .resolve("stitch-v2")
                              .resolve("xl-bank")
                              .resolve("stitch-rules.yaml").toAbsolutePath().toString()),
          'stitch-rules.yaml')

create_ci('Applications/XLDeploy', 'udm.Application')
create_ci('Applications/XLDeploy/9.6.0', 'udm.DeploymentPackage')
create_ci('Applications/XLDeploy/9.6.0/XLDeployConf',
          'yak.StitchFileResourceFile',
          {'ruleNamespace': 'xl', 'ruleName': 'satellite-config'},
          get_bytes_from_file(Paths.get(__file__).toAbsolutePath().getParent().getParent()
                              .resolve("src")
                              .resolve("main")
                              .resolve("resources")
                              .resolve("xld")
                              .resolve("stitch-v2")
                              .resolve("xl-deploy")
                              .resolve("stitch-rules.yaml").toAbsolutePath().toString()),
          'stitch-rules.yaml')
