def create_initial_deployment(task_to_create):
    app_id = task_to_create[1]
    env_id = task_to_create[2]
    user_name = task_to_create[3]
    run = task_to_create[4]

    depl_app = deployment.prepareInitial(app_id, env_id)
    depl_app = deployment.prepareAutoDeployeds(depl_app)
    task_id = deployment.createDeployTask(depl_app).id

    if user_name != 'admin':
        deployit.assignTask(task_id, user_name)

    if run:
        tasks_to_start.append(task_id)

    return task_id


def create_update_deployment(task_to_update):
    app_id = task_to_update[1]
    env_id = task_to_update[2]
    user_name = task_to_update[3]
    run = task_to_update[4]
    archive = task_to_update[5]

    depl_app = deployment.prepareUpgrade(app_id, env_id)
    depl_app = deployment.prepareAutoDeployeds(depl_app)
    task_id = deployment.createDeployTask(depl_app).id

    if user_name != 'admin':
        deployit.assignTask(task_id, user_name)

    if run:
        updated_tasks_to_start.append(task_id)

    if archive:
        tasks_to_archive.append(task_id)

    return task_id


def create_control_task_deployment(task_to_create):
    app_id = task_to_create[1]
    command_name = task_to_create[2]
    run = task_to_create[3]

    host4 = repository.read(app_id)
    control_task = deployit.prepareControlTask(host4, command_name)
    task_id = deployit.createControlTask(control_task)

    if run:
        tasks_to_start.append(task_id)

    return task_id


def schedule_initial_deployment(task_to_create):
    app_id = task_to_create[1]
    env_id = task_to_create[2]
    time = task_to_create[3]

    depl_app = deployment.prepareInitial(app_id, env_id)
    depl_app = deployment.prepareAutoDeployeds(depl_app)
    task_id = deployment.createDeployTask(depl_app).id
    task2.schedule(task_id, time)

    return task_id


def wait_till_no_active_tasks_left():
    wait = True

    while wait:
        print "Waiting for active tasks to complete."
        tasks_num = len(list(filter(lambda task: task.state is not None and task.state.isActive() and task.state != TaskExecutionState.SCHEDULED,
                                    task2.getAllCurrentTasks())))
        print "At the moment %s running task(s)" % (tasks_num)
        wait = tasks_num > 0
        time.sleep(2)
