#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

for _delta in deltas.deltas:
    deployed = _delta.deployedOrPrevious
    if (_delta.operation == "MODIFY") and (deployed.type == "helm.K8SRelease" or deployed.type == "helm.OpenshiftRelease"):
        if deployed.container.container.helmClient.showDiff:
            context.addStep(steps.jython(
                description="Preview of changes the helm upgrade would make.",
                order=59,
                script="helm/diff_upgrade.py",
                jython_context={"deployed": deployed,'helmclient': deployed.container.container.helmClient,'cluster': deployed.container.container},
                preview_script="helm/preview_diff_upgrade.py"
            ))

