#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

if deployed.type in ["helm.K8SRelease", "helm.OpenshiftRelease"]:
    container = deployed.container.container
    namespace = deployed.container.name
elif deployed.type == "helm.K8SReleaseWithNamespace":
    container = deployed.container
    namespace = deployed.namespace

if not container.helmClient:
    raise  Exception("Please Check if Helm Client is added in kubernetes/openshift CI.")

context.addStepWithCheckpoint(steps.helm(
    description="Upgrade the Helm {0} release on {1} namespace".format(deployed.name, namespace),
    order=60,
    script="helm/upgrade.py",
    jython_context={"deployed": deployed,'helmclient': container.helmClient,'cluster': container, 'satellite': container.helmClient.host.satellite},
    preview_script="helm/preview_upgrade.py"
), delta)
