/*
 * Decompiled with CFR 0.152.
 */
package org.xebialabs.googlecloud;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SelfLink {
    private String project;
    private String zone;
    private String name;
    public static final String REGEXP = "/compute/v1/projects/([^/]+)/zones/([^/]+)/instances/([^/]+)";

    public SelfLink(String selfLink) throws URISyntaxException {
        String path = new URI(selfLink).getPath().trim();
        Pattern pattern = Pattern.compile(REGEXP);
        Matcher matcher = pattern.matcher(path);
        if (!matcher.matches()) {
            throw new RuntimeException("Cannot decode " + selfLink);
        }
        this.project = matcher.group(1);
        this.zone = matcher.group(2);
        this.name = matcher.group(3);
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    public String getName() {
        return this.name;
    }
}

