#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from org.xebialabs.googlecloud  import GoogleCloudCompute

googleCompute = GoogleCloudCompute(deployed.container.clientEmail, deployed.container.privateKey, deployed.container.projectId)

instanceName = deployed.instanceName if deployed.instanceName else deployed.name
zone = deployed.zone

print("Wait for a new instance {} in {} ...".format(instanceName, zone))
if not googleCompute.isOperationDone(deployed.operationSelfLink, zone):
    result = "RETRY"
else:
    instance = googleCompute.getInstanceByName(instanceName, zone)
    print("instance is {0}".format(instance))
    deployed.instanceId = str(instance.getSelfLink())
    deployed.privateIp = instance.getNetworkInterfaces().get(0).getNetworkIP()
    if instance.getNetworkInterfaces().get(0).getAccessConfigs():
        deployed.publicIp = instance.getNetworkInterfaces().get(0).getAccessConfigs().get(0).getNatIP()
    print("instance ID is {0}".format(deployed.instanceId))
    print("private  IP is {0}".format(deployed.privateIp))
    print("public   IP is {0}".format(deployed.publicIp))
