#
import sys
from xlddocker import connect_to_docker
dkr = connect_to_docker(deployed.container)

service_name = deployed.serviceName or deployed.name

print "Retrieving current state of service", service_name
service = dkr.services.get(deployed.serviceId)

updateStatus = service.attrs['UpdateStatus']
if 'State' in updateStatus:
    updateStatusState = updateStatus['State']
    if updateStatusState == 'updating':
        print "Service", service_name, "is still being updated"
        result = "RETRY"
    elif updateStatusState == 'completed':
        print "Update of service", service_name, "to version", service.version, "has completed"
    else:
        print "Update of service", service_name, "has failed: ", service.attrs['UpdateStatus']['Message']
        sys.exit(1)
else:
    print "Cannot retrieve update status for service " + service_name + ". Assuming the update has completed"
