#
from xlddocker import connect_to_docker

dkr = connect_to_docker(deployed.container)

service_name = deployed.serviceName or deployed.name

print "Creating service", service_name, "for image", deployed.image

restart_policy = None
if deployed.restartPolicyName and deployed.restartPolicyName != 'none':
    restart_policy = {
        'Condition': deployed.restartPolicyName,
        'MaxAttempts': deployed.restartPolicyMaximumRetryCount}

mode = None
if deployed.mode == 'replicated':
    mode = {'Replicated': {'Replicas': deployed.replicas}}
elif deployed.mode == 'global':
    mode = {'Global': {}}

endpoint_config = {'Mode': deployed.endpointResolution,
                   'Ports': [{'Protocol': p.protocol, 'PublishedPort': p.published_port, 'TargetPort': p.target_port}
                             for p in deployed.portBindings]
                   }

update_config = {
    'Parallelism': deployed.updateParallelism,
    'Delay': deployed.updateDelay,
    'FailureAction': deployed.updateFailureAction}

service = dkr.services.create(
    command=deployed.command,
    container_labels=deployed.containerLabels,
    constraints=deployed.constraints,
    env=deployed.environment,
    image=deployed.image,
    labels=deployed.labels,
    mode=mode,
    name=service_name,
    networks=deployed.networks,
    restart_policy=restart_policy,
    update_config=update_config,
    workdir=deployed.workingDir,
    endpoint_spec=endpoint_config
)

deployed.serviceId = service.id
print "Service", service_name, "has been created with ID", deployed.serviceId
