from collections import deque
from sys import exit
from sys import stderr

GRAY, BLACK = 0, 1

def topological(graph):
    order, enter, state = deque(), set(graph), {}

    def dfs(node):
        state[node] = GRAY
        for k in graph.get(node, ()):
            sk = state.get(k, None)
            if sk == GRAY: raise ValueError("Error: cyclic dependency between containers")
            if sk == BLACK: continue
            enter.discard(k)
            dfs(k)
        order.appendleft(node)
        state[node] = BLACK

    while enter: dfs(enter.pop())
    return order

def created_modified_deployeds():
    deployed_set = set()
    for delta in deltas.deltas:
        if (delta.operation == "CREATE" or delta.operation == "MODIFY") and delta.deployedOrPrevious.type == "docker.Container":
            deployed_set.add(delta)
    return deployed_set

def sort_containers(containers):
    graph = {}
    for d in containers:
        if (d.deployed.containerName or d.deployed.name) in graph:
            print >> stderr, "Cannot use container name %s for more than one container in one package" % (d.deployed.containerName or d.deployed.name)
            exit(1)
        graph[d.deployed.containerName or d.deployed.name] = d.deployed.links.keys()

    sorted_containers = []
    for c in reversed(topological(graph)):
        sorted_containers.extend(filter(lambda d: (d.deployed.containerName or d.deployed.name) == c, containers))

    return sorted_containers

def run_container(delta):
    deployed = delta.deployed

    context.addStepWithCheckpoint(steps.jython(
        description="Pull Docker image %s on %s" % (deployed.image, deployed.container.name),
        order=5,
        script="xlddocker/pull_image.py",
        jython_context={'deployed': deployed}
    ), delta)

    context.addStepWithCheckpoint(steps.jython(
        description="Create Docker container %s on %s" % (deployed.containerName or deployed.name, deployed.container.name),
        order=70,
        script="xlddocker/create_container.py",
        jython_context={'deployed': deployed}
    ), delta)

    context.addStep(steps.jython(
        description="Start Docker container %s on %s" % (deployed.containerName or deployed.name, deployed.container.name),
        order=80,
        script="xlddocker/start_container.py",
        jython_context={'deployed': deployed}
    ))


max_showLogsAfter = 0
def find_max_showLogsAfter(delta):
    global max_showLogsAfter
    deployed = delta.deployed
    if deployed.showLogsAfter > max_showLogsAfter:
        max_showLogsAfter = deployed.showLogsAfter

docker_run_containers = created_modified_deployeds()
if len(docker_run_containers) > 0:
    sorted_docker_run_containers = sort_containers(docker_run_containers)
    map(run_container, sorted_docker_run_containers)
    map(find_max_showLogsAfter, sorted_docker_run_containers)
    if max_showLogsAfter:
        context.addStep(steps.wait(
            description="Wait for %d seconds" % max_showLogsAfter,
            order=81,
            seconds=max_showLogsAfter
        ))
