from xlddocker import get_derived_container_name
from xlddocker import get_deployed_name_from_container_name
from xlddocker import get_container_name

from collections import deque

GRAY, BLACK = 0, 1


def topological(graph):
    order, enter, state = deque(), set(graph), {}

    def dfs(node):
        state[node] = GRAY
        for k in graph.get(node, ()):
            sk = state.get(k, None)
            if sk == GRAY: raise ValueError("Error: cyclic dependency between containers")
            if sk == BLACK: continue
            enter.discard(k)
            dfs(k)
        order.appendleft(node)
        state[node] = BLACK

    while enter: dfs(enter.pop())
    return order

# This method checks for create and modified deployed
# If operation is modified it copies the old container name to the
# containerName property only if it was derived from deployed.name

def created_modified_deployeds():
    deployed_set = set()
    for delta in deltas.deltas:
        if delta.operation == "CREATE" and delta.deployedOrPrevious.type == "docker.Container":
            deployed_set.add(delta.deployed)
        elif delta.operation == "MODIFY" and delta.deployedOrPrevious.type == "docker.Container":
            old_container_name = delta.previous.containerName
            new_container_name = delta.deployed.containerName
            if old_container_name == new_container_name and get_deployed_name_from_container_name(old_container_name):
                delta.deployed.containerName = get_deployed_name_from_container_name(old_container_name)
            deployed_set.add(delta.deployed)
    return deployed_set

# This method overrides the container name value that user have entered
# If only it is derived from the application name, version and deployed.name

def get_updated_link(link):
    updated_link = link
    for delta in deltas.deltas:
        if delta.deployedOrPrevious.type == "docker.Container":
            if delta.operation == "MODIFY" or delta.operation == "CREATE":
                dep = delta.deployed
                deployed_name = dep.name
                if dep.containerName:
                    actual_container_name = dep.containerName
                else:
                    actual_container_name = get_derived_container_name(dep, deployedApplication)
            else:
                dep = delta.previous
                deployed_name = dep.name
                actual_container_name = dep.containerName
            if link == deployed_name:
                updated_link = actual_container_name
                break
    return updated_link

def create_docker_container(deployed):
    container_name = get_container_name(deployed, deployedApplication)
    if deployed.links:
        updatedLinks = {}
        for link, alias in deployed.links.items():
            updatedLinks[get_updated_link(link)] = alias
        deployed.links = updatedLinks

    context.addStep(steps.jython(
        description="Create Docker container %s on %s" % (container_name, deployed.container.name),
        order=61,
        script="xlddocker/create_container.py",
        jython_context={'deployed': deployed, 'deployedApplication': deployedApplication}
    ))

def start_docker_container(deployed):
    containername = get_container_name(deployed, deployedApplication)
    context.addStep(steps.jython(
        description="Start Docker container %s" % containername,
        order=64,
        script="xlddocker/start_container.py",
        jython_context={'deployed': deployed, 'deployedApplication': deployedApplication}
    ))

def sort_containers(docker_run_containers):
    graph = {}
    for d in docker_run_containers:
        data = set()
        data |= set([d.id.replace(d.name, link) for link in d.links.keys()])
        graph[d.id] = list(data)
    sorted_docker_run_containers = []
    for x in reversed(topological(graph)):
        filteredContainers = filter(lambda drc: drc.id == x, docker_run_containers)
        if filteredContainers.__len__() > 0:
            sorted_docker_run_containers.append(filteredContainers[0])
    return sorted_docker_run_containers

docker_run_containers = created_modified_deployeds()

if len(docker_run_containers) > 0:
    sorted_docker_run_containers = sort_containers(docker_run_containers)
    print "Sorted Docker Containers: %s" % sorted_docker_run_containers

    map(create_docker_container, sorted_docker_run_containers)
    map(start_docker_container, sorted_docker_run_containers)
