#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

#
import sys
from xlddocker import connect_to_docker
dkr = connect_to_docker(deployed.container)


nrOfRunningReplicas = 0

tasks = dkr.api.tasks()
for t in tasks:
    if t['ServiceID'] == deployed.serviceId and t['Status']['State'] == 'running':
        nrOfRunningReplicas += 1

print 'Nr of running replicas is %d.' % (nrOfRunningReplicas)

if nrOfRunningReplicas < deployed.waitForReplicasNr:
    counter_attr_name = 'wait_for_service_replicas_counter_%s' % (deployed.id)
    current_retry_count = context.getAttribute(counter_attr_name) or 0
    if current_retry_count < deployed.waitForReplicasMaxRetries:
        print 'Waiting until %d replicas are running.' % (deployed.waitForReplicasNr)
        current_retry_count += 1
        context.setAttribute(counter_attr_name, current_retry_count)
        result = "RETRY"
    else:
        print 'Exceeded maximum number of retries (%d). Giving up.' % (deployed.waitForReplicasMaxRetries)
        result = 1
