#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

#
from xlddocker import connect_to_docker
from xlddocker import print_docker_progress
dkr = connect_to_docker(deployed.container)
registries = deployed.container.registries
registry = None
authConf = None

# Split image name into repository and tag
last_colon = deployed.image.rfind(':')
last_slash = deployed.image.rfind('/')
has_tag = last_colon != -1 and (last_slash == -1 or last_slash < last_colon)
if has_tag:
    image_repository = deployed.image[:last_colon]
    image_tag = deployed.image[last_colon+1:]
else:
    image_repository = deployed.image
    image_tag = 'latest'

for r in registries:
    if r.url in image_repository:
        registry = r
        break

if registry:
    authConf = {'username':registry.username, 'password':registry.password}

print "Pulling", image_repository, "image with tag", image_tag
print_docker_progress(dkr.api.pull(repository=image_repository, tag=image_tag, stream=True, auth_config=authConf))
