#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

def stop_start_docker_container(deployed):
    if deployed is None:
        return

    context.addStep(steps.jython(
        description="Stop Docker container %s on %s" % (deployed.containerName or deployed.name, deployed.container.name),
        order=20,
        script="xlddocker/stop_container.py",
        jython_context={'previousDeployed': deployed}
    ))

    context.addStep(steps.jython(
        description="Start Docker container %s on %s" % (deployed.containerName or deployed.name, deployed.container.name),
        order=80,
        script="xlddocker/start_container.py",
        jython_context={'deployed': deployed}
    ))


def containers(modify_data_volume, noop_delta_container):
    candidates = []
    for delta_v in modify_data_volume:
        for delta in noop_delta_container:
            container = delta.deployed
            if container.name == delta_v.deployed.targetContainer:
                candidates.append(container)
            if container.name == delta_v.previous.targetContainer:
                candidates.append(container)

    return set(candidates)


modify_data_volume = filter(
    lambda delta: delta.operation == "MODIFY" and (delta.deployedOrPrevious.type == "docker.DeployedFolder" or delta.deployedOrPrevious.type == "docker.DeployedFile"),
    deltas.deltas)

noop_delta_container = filter(
    lambda delta: delta.operation == "NOOP" and delta.deployedOrPrevious.type == "docker.Container",
    deltas.deltas)

candidates = containers(modify_data_volume, noop_delta_container)

map(stop_start_docker_container, candidates)
