#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

def set_cf_path_from_dict(deployed, deployedApplication):
    for dictionary in deployedApplication.environment.dictionaries:
        for entry in dictionary.entries:
            if entry == "cfHome":
                deployed.container.cfHome = dictionary.entries[entry]
            if entry == "cliVersion":
                deployed.container.cliVersion = dictionary.entries[entry]
    return deployed

previousDeployed = set_cf_path_from_dict(previousDeployed, previousDeployedApplication)

context.addStep(steps.jython(
    description="Login into Cloud Foundry server [{}]".format(previousDeployed.container.apiEndpoint),
    order=55,
    script="cf/cf_login.py",
    jython_context={"deployed": previousDeployed}
))

context.addStepWithCheckpoint(steps.jython(
    description="Delete space [{}] on organization [{}]".format(previousDeployed.name, previousDeployed.container.organizationName),
    order=57,
    script="cf/space/delete_space.py",
    jython_context={"deployed": previousDeployed}
), delta)

context.addStep(steps.jython(
    description="Logout from Cloud Foundry server [{}]".format(previousDeployed.container.apiEndpoint),
    order=59,
    script="cf/cf_logout.py",
    jython_context={"deployed": previousDeployed}
))