#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

def set_cf_path_from_dict(deployed, deployedApplication):
    for dictionary in deployedApplication.environment.dictionaries:
        for entry in dictionary.entries:
            if entry == "cfHome":
                deployed.container.cfHome = dictionary.entries[entry]
            if entry == "cliVersion":
                deployed.container.cliVersion = dictionary.entries[entry]
    return deployed

deployed = set_cf_path_from_dict(deployed, deployedApplication)

context.addStep(steps.jython(
    description="Login into Cloud Foundry server [{}]".format(deployed.container.apiEndpoint),
    order=55,
    script="cf/cf_login.py",
    jython_context={"deployed": deployed},
    preview_script="cf/preview_login.py"
))

context.addStepWithCheckpoint(steps.jython(
    description="create space [{}] on organization [{}]".format(deployed.name, deployed.container.organizationName),
    order=57,
    script="cf/space/create_modify_space.py",
    jython_context={"deployed": deployed},
    preview_script="cf/space/planningScripts/preview_space.py"
), delta)

context.addStep(steps.jython(
    description="Logout from Cloud Foundry server [{}]".format(deployed.container.apiEndpoint),
    order=59,
    script="cf/cf_logout.py",
    jython_context={"deployed": deployed},
    preview_script="cf/preview_logout.py"
))