create_ci('Applications/ProvisioningPackage', 'udm.Application')
create_ci('Applications/ProvisioningPackage/1.0', 'udm.ProvisioningPackage')

create_ci('Applications/ProvisioningPackage/1.0/Spec', 'aws.ec2.InstanceSpec',
          {'amiId': 'ami-d91be1ae', 'region': 'eu-west-1', 'securityGroup': 'default',
           'instanceType': 'm1.small'})

create_ci('Applications/ProvisioningPackage/1.0/SshHost', 'template.overthere.SshHost',
          {'os': 'UNIX', 'connectionType': 'SUDO', 'address': '{{%publicHostname%}}',
           'username': 'ubuntu'})

create_ci('Applications/ProvisioningPackage/1.0/SshHost/Tomcat', 'template.tomcat.Server',
          {'home': '/opt/apache-tomcat', 'startCommand': 'sh bin/startup.sh',
           'stopCommand': 'sh bin/shutdown.sh', 'startWaitTime': 10, 'stopWaitTime': 10})


def update_provis_spec(ci):
    ci.boundTemplates = ['Applications/ProvisioningPackage/1.0/SshHost']


update_ci('Applications/ProvisioningPackage/1.0/Spec', update_provis_spec)

create_ci('Applications/ProvisioningPackage/1.0/Spec/Manifest', 'puppet.provisioner.Manifest',
          {'hostTemplate': 'Applications/ProvisioningPackage/1.0/SshHost',
           'fileUri': 'https://www.google.com'})

create_ci('Applications/ProvisioningPackage/1.0/Spec/puppetlabs-tomcat',
          'puppet.provisioner.Module', {'name': 'puppetlabs-tomcat',
                                        'hostTemplate': 'Applications/ProvisioningPackage/1.0/SshHost'})

create_ci('Applications/ProvisioningPackage/1.0/Spec/puppetlabs-java',
          'puppet.provisioner.Module', {'name': 'puppetlabs-java',
                                        'hostTemplate': 'Applications/ProvisioningPackage/1.0/SshHost'})

create_ci('Infrastructure/AwsCloud', 'aws.Cloud',
          {'accesskey': 'accesskey', 'accessSecret': 'accessSecret'})

create_ci('Infrastructure/AwsEc2Cloud', 'aws.Cloud',
                            {'os': 'UNIX', 'accesskey': 'accesskey',
                             'accessSecret': 'accessSecret'})
create_ci('Environments/AwsEc2Environment', 'udm.Environment', {'dictionaries': ['Environments/Defaults'], 'members': ['Infrastructure/AwsEc2Cloud']})
