create_ci('Configuration/credentials', 'credentials.UsernamePasswordCredentials',
                                            {'username': 'user', 'password': 'password'})
create_ci('Configuration/proxyHTTP', 'credentials.ProxyServer',
                                            {'protocol': 'HTTP', 'hostname': 'localhost', 'port': '3129'})
create_ci('Configuration/proxyHTTPS', 'credentials.ProxyServer',
                                            {'protocol': 'HTTPS', 'hostname': 'localhost', 'port': '3127'})

vaultFolder = 'Configuration/Vault'
create_ci(vaultFolder, 'core.Directory')
create_ci(vaultFolder + '/VaultServer', 'secrets.hashicorp.vault.Server', {
    'serverAddress': 'http://localhost:8201',
    'token': 'myroot'
})

create_ci(vaultFolder + '/VaultServer/SecretEngine', 'secrets.hashicorp.vault.SecretEngine', {
    'path': 'secret',
    'kvBackendVersion': 'VERSIONED'
})

create_ci(vaultFolder + '/VaultLookupValueProvider', 'secrets.hashicorp.vault.LookupValueProvider', {
    'vaultServer': vaultFolder + '/VaultServer',
    'secretPaths': ['secret/passwords']
})
