configurationOverthereSshHost = {
    'address': 'localhost',
    'connectionType': 'SUDO',
    'os': 'UNIX',
    'password': 'root',
    'port': '12345',
    'sudoUsername': 'root',
    'username': 'root'
}
create_ci('Applications/Placeholders', 'core.Directory')
create_ci('Environments/Placeholders', 'core.Directory')
placeholderDictsFolderId = 'Environments/Placeholders/Dictionaries'
placeholderTestDictsFolderId = 'Environments/Placeholders/Test-Dictionaries'
placeholderTestDictsFolderIdReadOnly = 'Environments/Placeholders/Test-Dictionaries-Read-Only'
create_ci(placeholderDictsFolderId, 'core.Directory')
create_ci(placeholderTestDictsFolderId, 'core.Directory')
create_ci(placeholderTestDictsFolderIdReadOnly, 'core.Directory')
create_ci('Infrastructure/Placeholders', 'core.Directory')

create_ci('Applications/Placeholders/AppForBlankPlaceholderValue', 'udm.Application')
create_ci('Applications/Placeholders/AppForBlankPlaceholderValue/1.0', 'placeholder.DeploymentPackage')

create_ci('Applications/Placeholders/AppForBlankPlaceholderValue/1.0/CommandBlank', 'xl.Command',
          {'commandLine': 'ls {{blank}}', 'undoCommandLine': 'ls {{blank_secret}}'})

create_ci('Applications/Placeholders/PlaceholderNoDeployedsApp', 'udm.Application')
create_ci('Applications/Placeholders/PlaceholderNoDeployedsApp/1.0', 'placeholder.DeploymentPackage',
          {'dependencyResolution': '{{dependencyResolution}}'})

create_ci('Applications/Placeholders/PlaceholderNoDeployedsApp/2.0',
          'placeholder.DeploymentPackage', {'dependencyResolution': '{{dependencyResolution}}'})

create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds', 'udm.Application')

create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds/1.0',
          'placeholder.DeploymentPackage')
create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds/1.0/Command', 'xl.Command',
          {'commandLine': '{{cmd}}', 'secret': '{{secret}}', 'undoCommandLine': 'sleep 3'})

create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds/2.0',
          'placeholder.DeploymentPackage')
create_ci('Applications/Placeholders/PlaceholderAppWithDeployeds/2.0/Command', 'xl.Command',
          {'commandLine': '{{cmd}}', 'secret': '{{secret}}', 'undoCommandLine': '{{multilineCmd}}'})

create_ci('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds', 'udm.Application')
create_ci('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0',
          'placeholder.DeploymentPackage')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0/Primary-{{primaryName}}',
    'example.ExamplePrimary')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0/Primary-{{primaryName}}/Embedded-{{embeddedName}}',
    'example.PrimaryEmbeddedDeployed')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0/Primary-{{primaryName}}/Embedded-{{embeddedName}}/Secondary-{{secondaryName}}',
    'example.EmbeddedVolumeSpec')

create_ci('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0',
          'placeholder.DeploymentPackage')
create_ci('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0/PrimaryPlaceholder',
          'example.ExamplePrimary')

create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0/Primary-{{primaryName}}',
    'example.ExamplePrimary')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0/Primary-{{primaryName}}/Embedded-{{embeddedName}}',
    'example.PrimaryEmbeddedDeployed')
create_ci(
    'Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0/Primary-{{primaryName}}/Embedded-{{embeddedName}}/Secondary-{{secondaryName}}',
    'example.EmbeddedVolumeSpec')

create_ci('Infrastructure/Placeholders/amsterdam-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/amsterdam-host/server', 'example.Server',
          {'home': '/tmp/amsterdam'})

create_ci('Infrastructure/Placeholders/haarlem-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/hilversum-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/zagreb-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/zagreb-host/server', 'example.Server',
          {'home': '/tmp/zagreb'})

create_ci('Infrastructure/Placeholders/split-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci('Infrastructure/Placeholders/dubrovnik-host', 'overthere.SshHost',
          configurationOverthereSshHost)

create_ci(placeholderDictsFolderId + '/Haarlem-Dictionary', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'ps -ef'
              },
              'restrictToContainers': [
                  'Infrastructure/Placeholders/haarlem-host'
              ]
          })

create_ci(placeholderDictsFolderId + '/Zagreb-Dictionary', 'udm.Dictionary',
         {
             'entries': {
                 'cmd': 'df -h'
             },
             'restrictToContainers': [
                 'Infrastructure/Placeholders/zagreb-host'
             ],
             'restrictToApplications': [
                 'Applications/Placeholders/PlaceholderAppWithDeployeds'
             ]
         })

create_ci(placeholderDictsFolderId + '/Dutch-Dictionary', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'date',
                  'dependencyResolution': 'LATEST',
                  'embeddedName': 'ENL',
                  'primaryName': 'PNL',
                  'secondaryName': 'SNL',
                  'usr': 'anki',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '%%_it_is_a_secret_%%'
              }
          })

create_ci(placeholderDictsFolderId + '/App-Restricted-Dictionary', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'pwd'
              },
              'restrictToApplications': [
                  'Applications/Placeholders/PlaceholderAppWithDeployeds'
              ]
          })

create_ci('Environments/Placeholders/Netherlands', 'xl.Environment',
          {
              'dictionaries': [
                  placeholderDictsFolderId + '/Haarlem-Dictionary',
                  placeholderDictsFolderId + '/App-Restricted-Dictionary',
                  placeholderDictsFolderId + '/Dutch-Dictionary'
              ],
              'members': [
                  'Infrastructure/Placeholders/amsterdam-host',
                  'Infrastructure/Placeholders/amsterdam-host/server',
                  'Infrastructure/Placeholders/haarlem-host',
                  'Infrastructure/Placeholders/hilversum-host'
              ]})

create_ci(placeholderDictsFolderId + '/Croatian-Dictionary', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'ls -al',
                  'multilineCmd': """# ghc-pkg-reset
                                # Removes all installed GHC/cabal packages, but not binaries, docs, etc.
                                # Use this to get out of dependency hell and start over, at the cost of some rebuilding time.
                                function ghc-pkg-reset() {
                                    read -p 'erasing all your user ghc and cabal packages - are you sure (y/n) ? ' ans
                                    test x$ans == xy && (
                                        echo 'erasing directories under ~/.ghc'; rm -rf `find ~/.ghc -maxdepth 1 -type d`;
                                        echo 'erasing ~/.cabal/lib'; rm -rf ~/.cabal/lib;
                                        # echo 'erasing ~/.cabal/packages'; rm -rf ~/.cabal/packages;
                                        # echo 'erasing ~/.cabal/share'; rm -rf ~/.cabal/share;
                                        )
                                }""",
                  'dependencyResolution': 'EXISTING',
                  'embeddedName': 'ECR',
                  'primaryName': 'PCR',
                  'secondaryName': 'SCR',
                  'usr': 'anki',
                  'PLACE_HOLDER': 'value',
                  'blank': ''
              },
              'encryptedEntries': {
                  'blank_secret': '',
                  'secret': '!!_it_is_a_secret_!!'
              },
              'restrictToApplications': [
                  "Applications/Placeholders/AppForBlankPlaceholderValue",
                  "Applications/Placeholders/PlaceholderAppWithDeployeds",
                  "Applications/Placeholders/PlaceholderNoDeployedsApp",
                  "Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds"
              ]
          })

create_ci('Environments/Placeholders/Croatia', 'xl.Environment',
          {
              'dictionaries': [
                  placeholderDictsFolderId + '/Zagreb-Dictionary',
                  placeholderDictsFolderId + '/Croatian-Dictionary'
              ],
              'members': [
                  'Infrastructure/Placeholders/zagreb-host',
                  'Infrastructure/Placeholders/zagreb-host/server',
                  'Infrastructure/Placeholders/dubrovnik-host',
                  'Infrastructure/Placeholders/split-host'
              ]
          })

create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary1', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command1',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary2', 'udm.Dictionary',
          {
              'entries': {
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'cmd': 'command2',
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderIdReadOnly + '/Vinodolski-Dictionary3', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command3',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderIdReadOnly + '/Vinodolski-Dictionary4', 'udm.Dictionary',
          {
              'entries': {
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'cmd': 'command4',
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary5', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command5',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary6', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command6',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })
create_ci(placeholderTestDictsFolderId + '/Vinodolski-Dictionary7', 'udm.Dictionary',
          {
              'entries': {
                  'cmd': 'command7',
                  'usr': 'tom',
                  'PLACE_HOLDER': 'value'
              },
              'encryptedEntries': {
                  'secret': '!!_it_is_a_secret_!!'
              }
          })

create_initial_task('Applications/Placeholders/PlaceholderNoDeployedsApp/1.0', 'Environments/Placeholders/Netherlands')
upgrade_task('Applications/Placeholders/PlaceholderNoDeployedsApp/2.0',
             'Environments/Placeholders/Netherlands/PlaceholderNoDeployedsApp')

create_initial_task('Applications/Placeholders/PlaceholderNoDeployedsApp/1.0', 'Environments/Placeholders/Croatia')
upgrade_task('Applications/Placeholders/PlaceholderNoDeployedsApp/2.0',
             'Environments/Placeholders/Croatia/PlaceholderNoDeployedsApp')

create_initial_task('Applications/Placeholders/PlaceholderAppWithDeployeds/1.0',
                    'Environments/Placeholders/Netherlands')
upgrade_task('Applications/Placeholders/PlaceholderAppWithDeployeds/2.0',
             'Environments/Placeholders/Netherlands/PlaceholderAppWithDeployeds')

create_initial_task('Applications/Placeholders/PlaceholderAppWithDeployeds/1.0', 'Environments/Placeholders/Croatia', 'admin', True, True)
upgrade_task('Applications/Placeholders/PlaceholderAppWithDeployeds/2.0',
             'Environments/Placeholders/Croatia/PlaceholderAppWithDeployeds')

create_initial_task('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0',
                    'Environments/Placeholders/Netherlands')
upgrade_task('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0',
             'Environments/Placeholders/Netherlands/PlaceholderAppWithEmbeddedDeployeds')

create_initial_task('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/1.0',
                    'Environments/Placeholders/Croatia')
upgrade_task('Applications/Placeholders/PlaceholderAppWithEmbeddedDeployeds/2.0',
             'Environments/Placeholders/Croatia/PlaceholderAppWithEmbeddedDeployeds')

create_initial_task('Applications/Placeholders/AppForBlankPlaceholderValue/1.0', 'Environments/Placeholders/Croatia', 'admin', True, True)

grant_permissions('task#takeover', 'test_role1', [placeholderDictsFolderId])
grant_permissions('read', 'test_role1', ['Environments/Placeholders'])
grant_permissions('read', 'test_role1', ['Infrastructure/Placeholders'])

grant_permissions('read', 'test_role2', ['Environments/Placeholders'])
grant_permissions('read', 'test_role2', [placeholderTestDictsFolderId])
grant_permissions('repo#edit', 'test_role2', [placeholderTestDictsFolderId])
grant_permissions('read', 'test_role2', [placeholderTestDictsFolderIdReadOnly])

def update_zagreb_dict(ci):
    ci['entries']['founded'] = 1094


update_ci(placeholderDictsFolderId + '/Zagreb-Dictionary', update_zagreb_dict)
