#!/bin/bash
DESTINATION=$(dirname "$0")
read -r -d '' ruleDocumentStart << ETX
kind: Rules
metadata:
  namespace: large-source
spec:
ETX

echo "$ruleDocumentStart" > "$DESTINATION/stitch-rules.yaml"

for i in {0..100}
do
  read -r -d '' ruleContent << ETXX
  - name: "rule-$i"
    condition:
      deployedType: yak.Json
    processor:
      - type: freemarker
        description: "Prints source file"
        parameters:
          template: |
            { "source": {
                 "file": {
                    "print":"yes"
                  }
                }
              }
ETXX
printf "  %s\n" "$ruleContent" >> "$DESTINATION/stitch-rules.yaml"
done

for i in {101..200}
do
read -r -d '' anotherRule << ETXX
---
kind: Rules
metadata:
  namespace: large-source
spec:
  - name: "another-rule-$i"
    condition:
      deployedType: yak.Json
    processor:
      - type: freemarker
        description: "Prints source file"
        weight: $i
        merge:
         type: overlay
        parameters:
          template: |
            { "source": {
                  "file": {
                    "print":"yes"
                  }
                }
              }
ETXX
printf "%s\n" "$anotherRule" >> "$DESTINATION/stitch-rules.yaml"
done
