create_user('john')
create_user('matt')
create_user('charles')
create_user('philip')

create_user('login_man')
assign_role("Login_only", ["login_man"])
grant_permissions("login", "Login_only")

create_user('report_man')
assign_role("Report_only", ["report_man"])
grant_permissions("report#view", "Report_only")

create_user('security_man')
assign_role("Security_only", ["security_man"])
grant_permissions("security#edit", "Security_only")

create_user('report_security_man')
assign_role("Report_Security_only", ["report_security_man"])
grant_permissions("report#view", "Report_Security_only")
grant_permissions("security#edit", "Report_Security_only")

create_user('read_man')
assign_role("Cis_reader_only", ["read_man"])
grant_permissions("read", "Cis_reader_only", ['Applications', 'Environments', 'Configuration', 'Infrastructure'])

create_user('repo_edit_man')
assign_role("Cis_editors_only", ["repo_edit_man"])
grant_permissions("read", "Cis_editors_only", ['Applications', 'Environments', 'Configuration', 'Infrastructure'])
grant_permissions("repo#edit", "Cis_editors_only", ['Applications', 'Environments', 'Configuration', 'Infrastructure'])

create_user('import_remove_man')
assign_role("App_removers", ["import_remove_man"])
grant_permissions("read", "App_removers", ['Applications'])
grant_permissions("import#remove", "App_removers", ['Applications'])

create_user('initial_deploy_man')
assign_role("Initial_deployers_only", ["initial_deploy_man"])
grant_permissions("read", "Initial_deployers_only", ['Applications', 'Environments'])
grant_permissions("deploy#initial", "Initial_deployers_only", ['Environments'])

create_user('deploy_upgrade_man')
assign_role("Deploy_Updaters_only", ["deploy_upgrade_man"])
grant_permissions("read", "Deploy_Updaters_only", ['Applications', 'Environments'])
grant_permissions("deploy#upgrade", "Deploy_Updaters_only", ['Environments'])

create_user('deploy_undeploy_man')
assign_role("Deploy_Undeployers_only", ["deploy_undeploy_man"])
grant_permissions("read", "Deploy_Undeployers_only", ['Applications', 'Environments'])
grant_permissions("deploy#undeploy", "Deploy_Undeployers_only", ['Environments'])

create_user('task_view_man')
assign_role('Task_View_Only', ['task_view_man'])
grant_permissions('task#view', 'Task_View_Only')
grant_permissions('task#assign', 'Task_View_Only')
grant_permissions("deploy#initial", "Task_View_Only", ['Environments'])
grant_permissions("read", "Task_View_Only", ['Applications', 'Environments', 'Infrastructure'])

for i in range(1, 10):
    username = 'charles'+ str(i)
    create_user(username)
    assign_role('test_role'+ str(i), [username])

grant_permissions("login", "test_role1")
grant_permissions("login", "test_role2")

for i in range(11, 30):
    assign_role('test_role'+ str(i), ['test_role_principal'+ str(i)])

assign_role("Login_only", [
    "login_man", "report_man", "security_man", "report_security_man",
    "read_man", "repo_edit_man", 'initial_deploy_man', 'deploy_undeploy_man',
    'deploy_upgrade_man', 'import_remove_man', 'task_view_man'
])

assign_role("developers", ["john", "matt"])
assign_role("administrators", ["charles"])
assign_role("observer", ["philip", "john"])
grant_permissions("login", "developers")
grant_permissions("report#view", "administrators")
grant_permissions("admin", "administrators")
grant_permissions("task#preview_step", "developers")
grant_permissions('controltask#execute', 'administrators', ['Applications'])
grant_permissions('import#initial', 'administrators', ['Applications'])
grant_permissions('repo#edit', 'administrators', ['Applications'])


create_user('read-only-user')
assign_role('deploy_admin_read_only', ['read-only-user'])

create_user('secured_ci_usr')
rolename_task_monitor = "secured_ci_task_monitor"
assign_role(rolename_task_monitor, ["secured_ci_usr"])
grant_permissions("login", rolename_task_monitor)
grant_permissions('task#assign',rolename_task_monitor)
grant_permissions('task#move_step',rolename_task_monitor)
grant_permissions('task#preview_step', rolename_task_monitor)
grant_permissions('task#view', rolename_task_monitor)
grant_permissions('report#view' ,rolename_task_monitor)
grant_permissions('discovery' ,rolename_task_monitor)
grant_permissions('task#takeover' ,rolename_task_monitor)
grant_permissions('controltask#execute' ,rolename_task_monitor)
grant_permissions('task#skip_step' ,rolename_task_monitor)

grant_permissions('read', rolename_task_monitor, ['Environments/PermissionTaskMonitorEnv'])
grant_permissions('controltask#execute', rolename_task_monitor, ['Environments/PermissionTaskMonitorEnv'])
grant_permissions('deploy#undeploy', rolename_task_monitor, ['Environments/PermissionTaskMonitorEnv'])
grant_permissions('deploy#initial', rolename_task_monitor, ['Environments/PermissionTaskMonitorEnv'])
grant_permissions('deploy#upgrade', rolename_task_monitor, ['Environments/PermissionTaskMonitorEnv'])
grant_permissions('task#skip_step', rolename_task_monitor, ['Environments/PermissionTaskMonitorEnv'])
grant_permissions('task#move_step', rolename_task_monitor, ['Environments/PermissionTaskMonitorEnv'])
grant_permissions('repo#edit', rolename_task_monitor, ['Environments/PermissionTaskMonitorEnv'])

grant_permissions('read', rolename_task_monitor, ['Infrastructure/PermissionTaskMonitorInfra'])
grant_permissions('controltask#execute', rolename_task_monitor, ['Infrastructure/PermissionTaskMonitorInfra'])
grant_permissions('repo#edit', rolename_task_monitor, ['Infrastructure/PermissionTaskMonitorInfra'])

grant_permissions('read', rolename_task_monitor, ['Applications/PermissionTaskMonitorApp'])
grant_permissions('controltask#execute', rolename_task_monitor, ['Applications/PermissionTaskMonitorApp'])
grant_permissions('repo#edit', rolename_task_monitor, ['Applications/PermissionTaskMonitorApp'])
