from xld.azure.connector import AzureConnector
from xld.azure import string_or_none
from xld.azure.blob_container.blob_file_helper import BlobFileHelper

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)

container_name = deployed.containerName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

account_key = string_or_none(deployed.accountKey)

if not (string_or_none(deployed.accountKey) or string_or_none(deployed.sasToken)):
    storage_client = connector.storage_client()
    storage_keys = storage_client.storage_accounts.list_keys(resource_group_name, deployed.storageAccountName)
    storage_keys = {v.key_name: v.value for v in storage_keys.keys}
    account_key = storage_keys['key1']
    deployed.accountKey = account_key

block_blob_service = BlobFileHelper(deployed).get_block_blobservice_from_deployed()

print "Block Blob Service created"

block_blob_service.create_container(
    container_name=container_name,
    metadata=deployed.metadata,
    public_access=deployed.publicAccess
)

deployed.containerUrl = block_blob_service.make_blob_url(container_name, '')

print "Container '{0}' created".format(container_name)
