from azure.mgmt.compute.models import AvailabilitySet, Sku
from xld.azure import get_operation_name

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
compute_client = connector.compute_client()

availability_set_name = deployed.availabilitySetName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

availability_set_parameters = AvailabilitySet(
    location=deployed.location,
    platform_update_domain_count=deployed.updateDomainCount,
    platform_fault_domain_count=deployed.faultDomainCount,
    virtual_machines=[],
    sku=Sku(
        name=deployed.sku
        )
    )

print "{0} Availability Set {1} under Resource Group {2}".format(get_operation_name(previousDeployed), availability_set_name,
                                                          resource_group_name)

# asynchronous
op_result = compute_client.availability_sets.create_or_update(
    resource_group_name=resource_group_name,
    availability_set_name=availability_set_name,
    parameters=availability_set_parameters,
    raw=True
)

logger.info("Result: {0}".format(op_result))
