from xld.azure.connector import AzureConnector
from azure.storage.blob import BlockBlobService

if previousDeployed.osDiskAutoRemove:

    rg = previousDeployed.container
    cloud = rg.container
    connector = AzureConnector(cloud)

    resource_group_name = rg.resourceGroupName or rg.name

    storage_client = connector.storage_client()

    storage_keys = storage_client.storage_accounts.list_keys(
        resource_group_name, previousDeployed.osStorageAccountName)
    storage_keys_names = list(storage_keys.keys)
    storage_keys = {v.key_name: v.value for v in storage_keys.keys}
    account_key = storage_keys[storage_keys_names[0].key_name]

    blockBlobService = BlockBlobService(
        account_name=previousDeployed.osStorageAccountName,
        account_key=account_key
    )

    delete_vhd_result = blockBlobService.delete_blob(
        container_name='vhds',
        blob_name="{0}.vhd".format(previousDeployed.osDiskName)
    )

    print delete_vhd_result
