import os.path
from xld.azure.connector import AzureConnector
from xld.azure.blob_container.blob_file_helper import BlobFileHelper


def process_files(root_dir, container_name):
    for subdir, dirs, files in os.walk(root_dir):
        for thefile in files:
            target_file_name = os.path.join(subdir.replace(root_dir, ''), thefile).strip("/")
            source_file_path = os.path.join(subdir, thefile)
            print "uploading {0} as {1}".format(source_file_path, target_file_name)
            blob_file_helper.upload_file_into_container(container_name, target_file_name, source_file_path)


bc = deployed.container  # blob container
rg = bc.container
cloud = rg.container
connector = AzureConnector(cloud)  # accomplish certifi patch

container_name = deployed.container.containerName or deployed.container.name

blob_file_helper = BlobFileHelper(deployed)
process_files(deployed.file.path, container_name)
