import time
from com.xebialabs.deployit.plugin.azure import AzureHelper

azure_helper = AzureHelper(deployed.container)

deploymentName = deployed.deploymentName
resourceGroupName = deployed.resourceGroupName

if not deploymentName or not deploymentName.strip():
    raise Exception("Template '%s' must have its 'Deployment Name' set" % deployed.name)

retry_count = 0
sleep_interval = 5

while True:
    retry_count += 1
    if retry_count > deployed.maxRetries:
        raise Exception("Deployment '%s' timed out waiting for 'Succeeded'." % deploymentName)

    if azure_helper.deploymentExists(resourceGroupName, deploymentName):
        state = azure_helper.getDeploymentState(deploymentName)
        if state:
            print('Current state is %s. Waiting 5 seconds.' % state)
            if state.lower() == 'failed':
                failureMessages = azure_helper.getFailedDeploymentOperations(deploymentName)
                raise Exception("Deployment '%s' failed [%s]" % (deploymentName, '\n'.join(failureMessages)))
            if state.lower() != 'running' and state.lower() != 'accepted':
                print("Final deployment state is '%s'" % state)
                break
    else:
        print("Deployment '%s' does not exist yet" % deploymentName)
    time.sleep(sleep_interval)
