# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource. This cannot be changed
     after the resource is created.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict
    :ivar provisioning_state: The provisioning state of the replication at the
     time the operation was called. Possible values include: 'Creating',
     'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
    :vartype provisioning_state: str or :class:`ProvisioningState
     <azure.mgmt.containerregistry.v2017_06_01_preview.models.ProvisioningState>`
    :ivar status: The status of the replication at the time the operation was
     called.
    :vartype status: :class:`Status
     <azure.mgmt.containerregistry.v2017_06_01_preview.models.Status>`
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
    }

    def __init__(self, location, tags=None):
        super(Replication, self).__init__(location=location, tags=tags)
        self.provisioning_state = None
        self.status = None
