import xml.etree.ElementTree as ET
import requests

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

print "Uploading Function App artifact {0} under Resource Group {1}".format(deployed.appName, rg.resourceGroupName)

# synchronous
credentials = web_client.web_apps.list_publishing_profile_xml_with_secrets(
    resource_group_name=rg.resourceGroupName,
    name=deployed.appName,
    format='Ftp'
)

#Parse credentials from XML
root = ET.XML(''.join(credentials))
for publishProfile in root:
    if publishProfile.attrib['publishMethod'] == 'MSDeploy':
        api_username = publishProfile.attrib['userName']
        api_password = publishProfile.attrib['userPWD']

upload_url="https://" + deployed.appName + ".scm.azurewebsites.net/api/zip/site/wwwroot"
files = open(deployed.file.path, 'rb')

r = requests.put(url=upload_url, data=files, auth=(api_username, api_password))

logger.info("Result: {0}".format(r))

functions_list = "https://management.azure.com/subscriptions/" + connector.subscription_id + "/resourceGroups/" + rg.resourceGroupName + "/providers/Microsoft.Web/sites/" + deployed.appName + "/functions?api-version=2016-08-01"
token = connector.credentials.token['access_token']
headers = {"Authorization":"Bearer " + token}
r = requests.get(url=functions_list, headers=headers)

logger.info("Result: {0}".format(r.json()))

functions = r.json()
for function in functions['value']:
    function_name = function['properties']['name']
    function_url = "https://" + deployed.appName + ".azurewebsites.net/api/" + function_name
    print "Uploaded function '" + function_name +"' -> " + function_url
