from xld.azure import wait_for_success_provisioning

from msrestazure.azure_exceptions import CloudError
from xld.azure.connector import AzureConnector

rg = previousDeployed.container
cloud = rg.container
connector = AzureConnector(cloud)
compute_client = connector.compute_client()

# synchronous
try:
    op_result = compute_client.virtual_machines.get(
        resource_group_name=rg.resourceGroupName,
        vm_name=previousDeployed.virtualMachineName,
        expand='instanceview'
    )

    print "VM details: {0}".format(op_result)

    result = wait_for_success_provisioning(op_result, previousDeployed.virtualMachineName)

    logger.info("Result: {0}".format(op_result))

except CloudError as e:
    print e.error.error
    if not (e.error.error in ['ResourceNotFound', 'NotFound']):
        raise
