from xld.azure.connector import AzureConnector

cloud = previousDeployed.container
connector = AzureConnector(cloud)
resource_client = connector.resource_client()
subscription_id = connector.subscription_id

# https://docs.microsoft.com/en-us/dotnet/api/microsoft.azure.management.resourcemanager.models.resourcegroup
# http://azure-sdk-for-python.readthedocs.io/en/latest/ref/azure.mgmt.resource.resources.html

# Required
# name Name of the resource group.

# Optional
# location Azure location for the resource group. Required when creating a new
# resource group. Cannot be changed once resource group is created.

# Unknown
# id String The ID of the resource group
# properties ResourceGroupProperties The location of the resource group.
# It cannot be changed after the resource group has been created. Has to be
# one of the supported Azure Locations, such as
# West US, East US, West Europe, East Asia, etc.
# managedBy String Id of the resource that manages this resource group.

resource_group_name = previousDeployed.resourceGroupName

logger.info("Checking existence of {0} under SubscriptionId {1}".format(resource_group_name, subscription_id))

is_group_present = resource_client.resource_groups.check_existence(
    resource_group_name=resource_group_name
)

logger.info("Resource is present: {0}".format(is_group_present))

if is_group_present:
    existing_resources = [i.id
                          for i in resource_client.resources.list_by_resource_group(
                              resource_group_name=resource_group_name)]
    if existing_resources:
        raise Exception("Group {0} has dependent resources:\n{1}".format(
            resource_group_name, "\n".join(existing_resources)))

    print "Deleting Resource Group {0} under SubscriptionId {1}".format(resource_group_name, subscription_id)

    # asynchronous
    op_result = resource_client.resource_groups.delete(
        resource_group_name=resource_group_name,
        custom_headers=None,
        raw=True
    )
    logger.info("Deleted: {0}".format(op_result))
