import xml.etree.ElementTree as ET
import json

from xld.azure.connector import AzureConnector

rg = deployed.container
clean_space = deployed.cleanTgtSpace
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

web_app_name = deployed.webAppName
resource_group_name = rg.resourceGroupName or rg.name

# retrieve scm endpoint
get_webapp_url = "https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Web/sites/{2}?api-version=2022-03-01".format(connector.subscription_id, resource_group_name, web_app_name)
token = "Bearer " + connector.credentials.token['access_token']
headers = {
    "Content-type": "application/json",
    "Authorization": token
}

webapp_response = connector.httpRequestHelper.executeRequest(get_webapp_url,"GET",json.dumps(headers),None,None)
if not int(webapp_response['statusCode']) < 300:
    print "Failed to retrieve webapp %s for reason:%s" % (web_app_name, webapp_response['response'])
    raise Exception("Failed to retrieve webapp %s. Check if it exists." % web_app_name)

enabledHostNames = []
response_obj = None
scm_hostname = None

try:
    response_obj = json.loads(webapp_response['response'])
    enabledHostNames = response_obj['properties']['enabledHostNames']

    for hostname in enabledHostNames:
        try:
            if ".scm." in hostname:
                scm_hostname = hostname
                print "SCM HostName identified %s" % scm_hostname
                break
        except:
            print "Failed to identify SCM HostName"
            logger.error("Failed to extract scm endpoint")

except Exception as e:
    logger.error("Error extracting webapp details {0}".format(web_app_name))
    print(e)

publishing_cred_url = "https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Web/sites/{2}/publishxml?api-version=2022-03-01".format(connector.subscription_id, resource_group_name, web_app_name)
token = "Bearer " + connector.credentials.token['access_token']
headers = {
    "Content-type": "application/json",
    "Authorization": token
}

headersOnlyToken = {
    "Authorization": token
}
req_body = json.dumps({"format": "Ftp"})
proxies=None
if connector.proxiesdict:
    proxies = json.dumps(connector.proxiesdict)

r1 = connector.httpRequestHelper.executeRequest(publishing_cred_url,"POST",json.dumps(headers),req_body,None)

print("Retrieve publishing credentials, status_code {0}".format(r1['statusCode']))
if not int(r1['statusCode']) < 300:
    print "Failed to retrieve publishing credentials for webapp reason:%s" % r1['response']
    raise Exception("Failed to retrieve publishing credentials for webapp %s" % web_app_name)

response_xml = r1['response']
print "Uploading Function App artifact {0} under Resource Group {1}".format(web_app_name, resource_group_name)
root = ET.XML(response_xml)
for publishProfile in root:
    if publishProfile.attrib['publishMethod'] == 'MSDeploy':
        api_username = publishProfile.attrib['userName']
        api_password = publishProfile.attrib['userPWD']

file_path = deployed.file.path
if deployed.artifactType:
    type=deployed.artifactType
else:
    type="zip"
    if file_path.endswith(".war"):
        type="war"
    elif file_path.endswith(".jar"):
        type="jar"
    elif file_path.endswith(".ear"):
        type="ear"

if scm_hostname:
    upload_url = "https://{0}/api/publish?type={1}&clean={2}".format(scm_hostname, type, clean_space)
else:
    upload_url = "https://{0}.scm.azurewebsites.net/api/publish?type={1}&clean={2}".format(web_app_name, type, clean_space)

if deployed.targetPath:
    upload_url = "%s&path='%s'" % (upload_url, deployed.targetPath)

print("upload url:%s" % upload_url)

r= connector.httpRequestHelper.executeRequest(upload_url,"POST",json.dumps(headersOnlyToken),None,deployed.file.path)
print "Upload artifact responsecode {0} response {1}".format(r['statusCode'], r['response'])

if not int(r['statusCode']) < 300:
    print "Failed to upload artifact for webapp reason:%s" % r['response']
    raise Exception("Failed to upload artifact for webapp %s" % web_app_name)
else:
    print "Artifact for webapp {0} uploaded under Resource Group {1}".format(web_app_name, resource_group_name)

logger.info("Result: {0}".format(r['response']))

if 'deploymentId' in r:
    print ("Deployment Id for the uploaded artifact %s" % r['deploymentId'])
    logger.info("Headers returned: {0}".format(r['headers']))
    deployed.deploymentId = r['deploymentId']
    deployed.statusCheckRetryCounter = 0
else:
    print("No Deployment Id returned for the uploaded artifact. Retrieving the latest Deployment Id from the Webapp.")
    get_webapp_deployments = "https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.Web/sites/{2}/deployments?api-version=2022-03-01".format(connector.subscription_id, resource_group_name, web_app_name)
    token = "Bearer " + connector.credentials.token['access_token']
    headers = {
        "Content-type": "application/json",
        "Authorization": token
    }

    deployments_response = connector.httpRequestHelper.executeRequest(get_webapp_deployments,"GET",json.dumps(headers),None,None)
    if not int(deployments_response['statusCode']) < 300:
        print "Failed to retrieve webapp, reason:%s" % r['response']

    enabledHostNames = []
    response_obj = json.loads(deployments_response['response'])
    deployments = response_obj['value']
    if deployments:
        deployment = deployments[0]
        deploymentId = deployment['properties']['id']
        print("Latest deployment id %s" % deploymentId)
        deployed.deploymentId = deploymentId
        deployed.statusCheckRetryCounter = 0
    else:
        print("Could not retrieve deployments for webapp %s" % web_app_name)

