from xld.azure import wait_for_success_provisioning

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)

compute_client = connector.compute_client()

resource_group_name = rg.resourceGroupName or rg.name
virtual_machine_name = deployed.virtualMachineName or deployed.name


# synchronous
op_result = compute_client.virtual_machines.get(
    resource_group_name=resource_group_name,
    vm_name=virtual_machine_name,
    expand='instanceview'
)

result = wait_for_success_provisioning(op_result, virtual_machine_name)

if (result == "SUCCESS" and op_result.instance_view.statuses and
        op_result.instance_view.statuses[1].code != 'PowerState/running'):
    print "Waiting for {0} to be started ({1})".format(virtual_machine_name, op_result.provisioning_state)
    result = "RETRY"

logger.info("Result: {0}".format(op_result))
