from xld.azure.connector import AzureConnector
import requests

rg = previousDeployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

function_app_name = previousDeployed.appName or previousDeployed.name
resource_group_name = rg.resourceGroupName or rg.name
fx_version = previousDeployed.linuxFxVersion

print "Deleting Function App {0} under Resource Group {1}".format(function_app_name, resource_group_name)
token = "Bearer " + connector.credentials.token['access_token']
headers = {
    "Content-type": "application/json",
    "Authorization": token
}
delete_funcapp_url= "https://management.azure.com/subscriptions/"+ connector.subscription_id +"/resourceGroups/"+ resource_group_name +"/providers/Microsoft.Web/sites/" + function_app_name + "?deleteEmptyServerFarm=False&api-version=2022-03-01"
r = requests.delete(url=delete_funcapp_url, headers=headers)

logger.info("Result: {0}".format(r.status_code))

# service plan is not created from deploy for docker based functions
if fx_version is not None and not fx_version.lower().startswith("docker"):
    op_result = web_client.app_service_plans.delete(
        resource_group_name=resource_group_name,
        name=previousDeployed.servicePlanName,
        raw=True
    )
    logger.info("Result: {0}".format(op_result))
    print "Deleted App Service Plan {0} under Resource Group {1}".format(previousDeployed.servicePlanName, resource_group_name)

