from azure.mgmt.web.models.application_logs_config import ApplicationLogsConfig
from azure.mgmt.web.models.azure_blob_storage_application_logs_config import AzureBlobStorageApplicationLogsConfig
from azure.mgmt.web.models.file_system_application_logs_config import FileSystemApplicationLogsConfig
from azure.mgmt.web.models.site_logs_config import SiteLogsConfig
from azure.mgmt.web.models.azure_blob_storage_http_logs_config import AzureBlobStorageHttpLogsConfig
from azure.mgmt.web.models.file_system_http_logs_config import FileSystemHttpLogsConfig
from azure.mgmt.web.models.http_logs_config import HttpLogsConfig
from azure.mgmt.web.models.enabled_config import EnabledConfig

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

resource_group_name = rg.resourceGroupName or rg.name
resource_group_location = rg.location
web_app_name = deployed.webAppName

print "Configuring logging for Web App {0} under Resource Group {1}".format(web_app_name, resource_group_name)

# Application logging configuration
application_logs_config = ApplicationLogsConfig()
if deployed.applicationLoggingFileSystem == "On":
    application_logs_config.file_system = FileSystemApplicationLogsConfig(level=deployed.applicationLoggingFileSystemLevel)
elif deployed.applicationLoggingFileSystem == "Off":
    application_logs_config.file_system = FileSystemApplicationLogsConfig()
else:
    application_logs_config.file_system = None

if deployed.applicationLoggingBlob == "On":
    application_logs_config.azure_blob_storage = AzureBlobStorageApplicationLogsConfig(level=deployed.applicationLoggingBlobLevel, sas_url=deployed.applicationLoggingBlobStorage, retention_in_days=deployed.applicationLoggingBlobRetention)
elif deployed.applicationLoggingBlob == "Off":
    application_logs_config.azure_blob_storage = AzureBlobStorageApplicationLogsConfig()
else:
    application_logs_config.azure_blob_storage = None

# Web server logging configuration
http_logs_config = HttpLogsConfig()
if deployed.httpLogs == "FileSystem":
    http_logs_config.file_system = FileSystemHttpLogsConfig(retention_in_mb=deployed.httpFileSystemQuota, retention_in_days=deployed.httpFileSystemRetention, enabled=EnabledConfig(True))
elif deployed.httpLogs == "Storage":
    http_logs_config.azure_blob_storage = AzureBlobStorageHttpLogsConfig(sas_url=deployed.httpStorageStorage, retention_in_days=deployed.httpStorageRetention, enabled=EnabledConfig(True))
elif deployed.httpLogs == "Off":
    http_logs_config.file_system = FileSystemHttpLogsConfig()
    http_logs_config.azure_blob_storage = AzureBlobStorageHttpLogsConfig()
else:
    http_logs_config = None

# Detailed error messages (on/off)
if deployed.detailedErrorMessages == "On":
    errorMessages = EnabledConfig(True)
elif deployed.detailedErrorMessages == "Off":
    errorMessages = EnabledConfig(False)
else:
    errorMessages = None

# Failed requests tracing (on/off)
if deployed.failedRequestsTracing == "On":
    failedRequestsTracing = EnabledConfig(True)
elif deployed.failedRequestsTracing == "Off":
    failedRequestsTracing = EnabledConfig(False)
else:
    failedRequestsTracing = None

site_logs_config = SiteLogsConfig(location=resource_group_location, kind="Site", name=web_app_name, application_logs=application_logs_config, http_logs=http_logs_config, failed_requests_tracing=failedRequestsTracing, detailed_error_messages=errorMessages)

result = web_client.web_apps.update_diagnostic_logs_config(resource_group_name=resource_group_name, name=web_app_name, site_logs_config=site_logs_config)

logger.info("result:  {}", result)

print "Successfully configured web app logging."
