from azure.mgmt.compute.models import ImageReference, NetworkInterfaceReference
from azure.mgmt.compute.models import OSDisk
from azure.mgmt.compute.models import SshPublicKey, SshConfiguration
from azure.mgmt.compute.models import StorageProfile, OSProfile, NetworkProfile, HardwareProfile
from azure.mgmt.compute.models import VirtualHardDisk, VirtualMachine
from azure.mgmt.compute.models import WindowsConfiguration, LinuxConfiguration, WinRMConfiguration, WinRMListener
from azure.mgmt.compute.models import VaultSecretGroup, VaultCertificate, SourceVault
from azure.mgmt.network.models import SubResource

from xld.azure.connector import AzureConnector


def get_os_profile(admin_username, admin_password, computer_name, windows_configuration, linux_configuration,
                   custom_data, vault_secrets=None):
    return OSProfile(
        admin_username=admin_username,
        admin_password=admin_password,
        computer_name=computer_name,
        custom_data=custom_data,
        windows_configuration=windows_configuration,
        linux_configuration=linux_configuration,
        secrets=vault_secrets
    )


def get_vhd_uri(storage_name, vhd_name):
    return 'https://{0}.blob.core.windows.net/vhds/{1}.vhd'.format(
        storage_name,
        vhd_name,
    )


def get_storage_profile(disk_name, disk_vhd_uri, caching, create_option, disk_size_gb):
    return StorageProfile(
        image_reference=None,
        os_disk=OSDisk(
            name=disk_name,
            vhd=VirtualHardDisk(
                uri=disk_vhd_uri
            ),
            create_option=create_option,
            os_type=None,
            encryption_settings=None,
            image=None,
            caching=caching,
            disk_size_gb=disk_size_gb
        ),
        data_disks=None
    )


def get_network_profile(interfaces, resource_group_name):
    vm_network_interfaces = []
    for interface in interfaces:
        print "Looking up network interface {0}".format(interface)
        vm_network_interface = network_client.network_interfaces.get(
            resource_group_name,
            interface
        )
        print "Resolved to {0}".format(vm_network_interface.id)
        vm_network_interfaces.append(NetworkInterfaceReference(id=vm_network_interface.id))
    return NetworkProfile(network_interfaces=vm_network_interfaces)


def get_hardware_profile(the_vm_size):
    return HardwareProfile(
        vm_size=the_vm_size
    )


rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)

compute_client = connector.compute_client()
network_client = connector.network_client()

resource_group_name = rg.resourceGroupName or rg.name
virtual_machine_name = deployed.virtualMachineName or deployed.name

if deployed.osStorageAccountName:
    vm_disk_vhd_uri = get_vhd_uri(deployed.osStorageAccountName, deployed.osDiskName)
else:
    vm_disk_vhd_uri = deployed.osVhd

vm_storage_profile = get_storage_profile(
    disk_name=deployed.osDiskName,
    disk_vhd_uri=vm_disk_vhd_uri,
    caching=deployed.caching,
    create_option=deployed.createOption,
    disk_size_gb=deployed.diskSizeGb)

vm_storage_profile.image_reference = ImageReference(
    publisher=deployed.publisher,
    offer=deployed.offer,
    sku=deployed.sku,
    version=deployed.version
)

vm_linux_configuration = None
if deployed.enableLinuxConfiguration:
    ssh_config = None
    if deployed.publicKeys:
        ssh_config = SshConfiguration()
        ssh_config.public_keys = [SshPublicKey(path=key, key_data=value)
                                  for key, value in deployed.publicKeys.iteritems()]
    print "configuring keys {0} via linux configuration , password authentication is {1}".format(
        ssh_config.public_keys,
        deployed.disablePasswordAuthentication)
    vm_linux_configuration = LinuxConfiguration(
        disable_password_authentication=deployed.disablePasswordAuthentication,
        ssh=ssh_config)

vm_windows_configuration = None
win_vault_secrets = None
if deployed.enableWindowsConfiguration:
    kv_managing_client = connector.keyvault_management_client()
    win_rm_listeners = []
    for listener in deployed.winrmListeners:
        certificate_url = None
        if listener.protocol=="Https":

            vault_info = kv_managing_client.vaults.get(
                resource_group_name=resource_group_name,
                vault_name=listener.certificateVaultName
            )

            if listener.certificateUrl:
                certificate_url=listener.certificateUrl
            else:
                kv_client = connector.keyvault_client()
                existing_secret_versions_iter = kv_client.get_secret_versions(
                    vault_base_url=vault_info.properties.vault_uri,
                    secret_name=listener.certificateSecretName,
                    maxresults=25
                )

                secret_certificate_versions = list(existing_secret_versions_iter)
                if len(secret_certificate_versions) > 0:
                    certificate_secret = secret_certificate_versions[0]
                    certificate_url = certificate_secret.id

            print vault_info.id
            win_vault_secrets = []
            win_vault_secrets.append(VaultSecretGroup(
                source_vault=SubResource(id=vault_info.id),
                vault_certificates=[
                    VaultCertificate(
                        certificate_url=certificate_url,
                        certificate_store="My"
                    )
                ]
            ))

        win_rm_listeners.append(
            WinRMListener(
                protocol=listener.protocol,
                certificate_url=certificate_url
            )
        )

    winrm_config = None
    if len(win_rm_listeners)>0:
        winrm_config=WinRMConfiguration(
            listeners=win_rm_listeners
        )

    vm_windows_configuration = WindowsConfiguration(
        provision_vm_agent=deployed.provisionVmAgent,
        enable_automatic_updates=deployed.enableAutomaticUpdates,
        time_zone=deployed.timeZone,
        additional_unattend_content=None,
        win_rm=winrm_config
    )

availability_set = None
if deployed.availabilitySet:
    availability_set_info = compute_client.availability_sets.get(
        resource_group_name=resource_group_name,
        availability_set_name=deployed.availabilitySet)
    availability_set = SubResource(availability_set_info.id)

vm_params_create = VirtualMachine(
    location=deployed.location,
    tags=deployed.virtualMachineTags,
    plan=None,
    os_profile=get_os_profile(
        admin_username=deployed.adminUserName,
        admin_password=deployed.adminPassword,
        computer_name=deployed.computerName,
        linux_configuration=vm_linux_configuration,
        windows_configuration=vm_windows_configuration,
        custom_data=deployed.customData,
        vault_secrets=win_vault_secrets
        ),
    hardware_profile=get_hardware_profile(deployed.vmSize),
    storage_profile=vm_storage_profile,
    network_profile=get_network_profile(deployed.networkInterfaces, resource_group_name),
    diagnostics_profile=None,
    availability_set=availability_set,
    license_type=None
)

print "Creating VM {0} on {1} ....".format(virtual_machine_name, resource_group_name)

# Create VM
op_result = compute_client.virtual_machines.create_or_update(
    resource_group_name=resource_group_name,
    vm_name=virtual_machine_name,
    parameters=vm_params_create,
    raw=True
)
logger.info("Result: {0}".format(op_result))
