from azure.mgmt.web.models import AppServicePlan, SkuDescription, Site, SiteConfig, NameValuePair

from xld.azure import get_operation_name, string_or_none
from xld.azure.blob_container.blob_file_helper import BlobFileHelper
from xld.azure.connector import AzureConnector

rg = deployed.container
app_settings = deployed.appSettings
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()
storage_client = connector.storage_client()

function_app_name = deployed.appName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name
os_type = deployed.osType

print "{0} Function App {1} under Resource Group {2}".format(
    get_operation_name(previousDeployed),
    function_app_name,
    resource_group_name)

storage_keys = storage_client.storage_accounts.list_keys(resource_group_name, deployed.storageAccount)
storage_keys = {v.key_name: v.value for v in storage_keys.keys}
connection_string = "DefaultEndpointsProtocol=https;AccountName=" + deployed.storageAccount + ";AccountKey=" + storage_keys['key1'] + ";EndpointSuffix=core.windows.net"

function_app_settings = [NameValuePair(name='WEBSITES_ENABLE_APP_SERVICE_STORAGE', value='false')]

for key in ['WEBSITE_CONTENTAZUREFILECONNECTIONSTRING','AzureWebJobsStorage']:
    function_app_settings.append(NameValuePair(name=key, value=connection_string))

for key in app_settings:
    function_app_settings.append(NameValuePair(name=key, value=app_settings[key]))

server_farm_id = "/subscriptions/" + connector.subscription_id + "/resourceGroups/" + resource_group_name + "/providers/Microsoft.Web/serverfarms/" + deployed.servicePlanName

# asynchronous
site_config=SiteConfig(
    app_settings=function_app_settings,
)

kind ="functionapp,linux"
linux_fx_version = deployed.linuxFxVersion
if not linux_fx_version:
    raise Exception('Linux Fx Version mandatory for Linux Service plans')
site_config.linux_fx_version = linux_fx_version

# Set docker parameters
if deployed.dockerRegistryUrl:
    function_app_settings.append(NameValuePair(name='DOCKER_REGISTRY_SERVER_URL', value=deployed.dockerRegistryUrl))
if deployed.dockerRegistryUsername:
    function_app_settings.append(NameValuePair(name='DOCKER_REGISTRY_SERVER_USERNAME', value=deployed.dockerRegistryUsername))
if deployed.dockerRegistryPassword:
    function_app_settings.append(NameValuePair(name='DOCKER_REGISTRY_SERVER_PASSWORD', value=deployed.dockerRegistryPassword))
if deployed.dockerCustomImageName:
    function_app_settings.append(NameValuePair(name='DOCKER_CUSTOM_IMAGE_NAME', value=deployed.dockerCustomImageName))

op_result = web_client.web_apps.create_or_update(
    resource_group_name=resource_group_name,
    name=function_app_name,
    site_envelope=Site(
        location=deployed.location,
        kind=kind,
        server_farm_id=server_farm_id,
        site_config=site_config,
        https_only= True if deployed.isHttpsOnly else False
    ),
    raw=True
)

logger.info("Result: {0}".format(op_result))

deployed.function_app_url = "https://" + function_app_name + ".azurewebsites.net/api/"

