from xld.azure.arm.helper import TemplateHelper
from xld.azure.AzurePythonHelper import AzurePyHelper

cf_template = AzurePyHelper.loadTemplate(deployed.file.path, deployed.armTemplateFileEncoding)

# if "stitch" in dir():
#     cf_template = TemplateHelper(deployed, cf_template, stitch).transform_template()

if deployed.createNewResourceGroup:
    context.addStep(steps.jython(
        description="Create Resource Group %s on %s" % (deployed.resourceGroupName, deployed.container.name),
        jython_context={"cf_template": cf_template},
        script="xld/azure/resource_group/create-or-update.py"
    ))
    context.addStep(steps.jython(
        description="Wait for Resource Group %s on %s to be created" % (deployed.resourceGroupName, deployed.container.name),
        script="xld/azure/resource_group/create_wait.py"
    ))

context.addStepWithCheckpoint(steps.jython(
    description="Create Resources : Submit template for creation",
    jython_context={"cf_template": cf_template},
    script="xld/azure/arm/create_resources_rest.py",
    preview_script="xld/azure/arm/create_resources_preview.py"
), delta)

context.addStep(steps.jython(
    description="Wait for Resources in %s to be fully created" % (deployed.resourceGroupName),
    script="xld/azure/arm/wait_for_ready_rest.py"
))

context.addStep(steps.jython(
    description="Capture output variables from Resource Group %s" % (deployed.resourceGroupName),
    script="xld/azure/arm/capture_output.py"
))
