# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Solution(Model):
    """Class Representing Solution for problems detected.

    :param id: Solution Id.
    :type id: float
    :param display_name: Display Name of the solution
    :type display_name: str
    :param order: Order of the solution.
    :type order: float
    :param description: Description of the solution
    :type description: str
    :param type: Type of Solution. Possible values include: 'QuickSolution',
     'DeepInvestigation', 'BestPractices'
    :type type: str or ~azure.mgmt.web.models.SolutionType
    :param data: Solution Data.
    :type data: list[list[~azure.mgmt.web.models.NameValuePair]]
    :param metadata: Solution Metadata.
    :type metadata: list[list[~azure.mgmt.web.models.NameValuePair]]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'float'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'order': {'key': 'order', 'type': 'float'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'SolutionType'},
        'data': {'key': 'data', 'type': '[[NameValuePair]]'},
        'metadata': {'key': 'metadata', 'type': '[[NameValuePair]]'},
    }

    def __init__(self, id=None, display_name=None, order=None, description=None, type=None, data=None, metadata=None):
        super(Solution, self).__init__()
        self.id = id
        self.display_name = display_name
        self.order = order
        self.description = description
        self.type = type
        self.data = data
        self.metadata = metadata
