/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.SubResource;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.CloudServiceInner;
import com.azure.resourcemanager.compute.models.CloudServiceNetworkProfile;
import com.azure.resourcemanager.compute.models.CloudServiceProperties;
import com.azure.resourcemanager.compute.models.CloudServiceRoleProfile;
import com.azure.resourcemanager.compute.models.CloudServiceRoleProfileProperties;
import com.azure.resourcemanager.compute.models.CloudServiceRoleSku;
import com.azure.resourcemanager.compute.models.LoadBalancerConfiguration;
import com.azure.resourcemanager.compute.models.LoadBalancerConfigurationProperties;
import com.azure.resourcemanager.compute.models.LoadBalancerFrontendIpConfiguration;
import com.azure.resourcemanager.compute.models.LoadBalancerFrontendIpConfigurationProperties;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.azure.AzureCredentials;
import com.xebialabs.deployit.plugin.azure.package$;
import java.util.Map;
import org.python.core.PyObject;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\u0007\u000e\u0001aA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tM\u0001\u0011\t\u0011)A\u0005O!)Q\u0006\u0001C\u0001]!)Q\u0006\u0001C\u0001e!9\u0001\t\u0001b\u0001\n\u0003\t\u0005BB&\u0001A\u0003%!\tC\u0003M\u0001\u0011\u0005Q\nC\u0003d\u0001\u0011\u0005A\rC\u0003r\u0001\u0011\u0005!\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\t\u00112\t\\8vIN+'O^5dK\u000ec\u0017.\u001a8u\u0015\tqq\"A\u0003buV\u0014XM\u0003\u0002\u0011#\u00051\u0001\u000f\\;hS:T!AE\n\u0002\u0011\u0011,\u0007\u000f\\8zSRT!\u0001F\u000b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001c\u001b\u0005i\u0011B\u0001\u000f\u000e\u0005A\t%0\u001e:f\u0007J,G-\u001a8uS\u0006d7/A\u0003dY>,H\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005\u0019Q\u000fZ7\u000b\u0005\rz\u0011aA1qS&\u0011Q\u0005\t\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0017aB2p]R,\u0007\u0010\u001e\t\u0003Q-j\u0011!\u000b\u0006\u0003U\t\nAA\u001a7po&\u0011A&\u000b\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDcA\u00181cA\u0011!\u0004\u0001\u0005\u0006;\r\u0001\rA\b\u0005\u0006M\r\u0001\ra\n\u000b\u0004_Mz\u0004\"\u0002\u001b\u0005\u0001\u0004)\u0014a\u00029z\u00072|W\u000f\u001a\t\u0003muj\u0011a\u000e\u0006\u0003qe\nAaY8sK*\u0011!hO\u0001\u0007af$\bn\u001c8\u000b\u0003q\n1a\u001c:h\u0013\tqtG\u0001\u0005Qs>\u0013'.Z2u\u0011\u00151C\u00011\u0001(\u00039\u0019w.\u001c9vi\u0016l\u0015M\\1hKJ,\u0012A\u0011\t\u0003\u0007&k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bqaY8naV$XM\u0003\u0002H\u0011\u0006y!/Z:pkJ\u001cW-\\1oC\u001e,'O\u0003\u0002\u000f+%\u0011!\n\u0012\u0002\u000f\u0007>l\u0007/\u001e;f\u001b\u0006t\u0017mZ3s\u0003=\u0019w.\u001c9vi\u0016l\u0015M\\1hKJ\u0004\u0013A\u00053fY\u0016$Xm\u00117pk\u0012\u001cVM\u001d<jG\u0016$2A\u0014+b!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0011)f.\u001b;\t\u000bU;\u0001\u0019\u0001,\u0002#I,7o\\;sG\u0016<%o\\;q\u001d\u0006lW\r\u0005\u0002X=:\u0011\u0001\f\u0018\t\u00033Bk\u0011A\u0017\u0006\u00037^\ta\u0001\u0010:p_Rt\u0014BA/Q\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\u0003\u0006\"\u00022\b\u0001\u00041\u0016\u0001E2m_V$7+\u001a:wS\u000e,g*Y7f\u0003I)\b\u000fZ1uK\u000ecw.\u001e3TKJ4\u0018nY3\u0015\t9+gm\u001a\u0005\u0006+\"\u0001\rA\u0016\u0005\u0006E\"\u0001\rA\u0016\u0005\u0006Q\"\u0001\r![\u0001\u0005i\u0006<7\u000f\u0005\u0003k_Z3V\"A6\u000b\u00051l\u0017\u0001B;uS2T\u0011A\\\u0001\u0005U\u00064\u0018-\u0003\u0002qW\n\u0019Q*\u00199\u0002A\r\u0014X-\u0019;f\u00072|W\u000fZ*feZL7-\u001a(fi^|'o\u001b)s_\u001aLG.\u001a\u000b\u0006gfTHP \t\u0003i^l\u0011!\u001e\u0006\u0003m\u0012\u000ba!\\8eK2\u001c\u0018B\u0001=v\u0005i\u0019En\\;e'\u0016\u0014h/[2f\u001d\u0016$xo\u001c:l!J|g-\u001b7f\u0011\u0015)\u0016\u00021\u0001W\u0011\u0015Y\u0018\u00021\u0001W\u0003M\u0001XO\u00197jG&\u0003\u0016\t\u001a3sKN\u001ch*Y7f\u0011\u0015i\u0018\u00021\u0001W\u0003Aaw.\u00193CC2\fgnY3s\u001d\u0006lW\rC\u0003\u0000\u0013\u0001\u0007a+\u0001\u000em_\u0006$')\u00197b]\u000e,'O\u0012:p]R,e\u000eZ%q\u001d\u0006lW-A\u000fde\u0016\fG/Z\"m_V$7+\u001a:wS\u000e,'k\u001c7f!J|g-\u001b7f))\t)!a\u0003\u0002\u0010\u0005e\u0011Q\u0004\t\u0004i\u0006\u001d\u0011bAA\u0005k\n92\t\\8vIN+'O^5dKJ{G.\u001a)s_\u001aLG.\u001a\u0005\u0007\u0003\u001bQ\u0001\u0019\u0001,\u0002\u000fM\\WOT1nK\"9\u0011\u0011\u0003\u0006A\u0002\u0005M\u0011aC:lk\u000e\u000b\u0007/Y2jif\u00042aTA\u000b\u0013\r\t9\u0002\u0015\u0002\u0004\u0013:$\bBBA\u000e\u0015\u0001\u0007a+A\u0004tWV$\u0016.\u001a:\t\r\u0005}!\u00021\u0001W\u0003!\u0011x\u000e\\3OC6,\u0017AE2sK\u0006$Xm\u00117pk\u0012\u001cVM\u001d<jG\u0016$\u0012DTA\u0013\u0003O\tI#a\u000b\u00020\u0005E\u00121GA\u001c\u0003w\ti$a\u0010\u0002B!)Qk\u0003a\u0001-\")!m\u0003a\u0001-\")1p\u0003a\u0001-\"1\u0011QF\u0006A\u0002Y\u000b\u0001\u0002\\8dCRLwN\u001c\u0005\u0006{.\u0001\rA\u0016\u0005\u0006\u007f.\u0001\rA\u0016\u0005\u0007\u0003kY\u0001\u0019\u0001,\u0002!\r|gNZ5hkJ\fG/[8o+Jd\u0007BBA\u001d\u0017\u0001\u0007a+\u0001\u0006qC\u000e\\\u0017mZ3Ve2Da!!\u0004\f\u0001\u00041\u0006bBA\t\u0017\u0001\u0007\u00111\u0003\u0005\u0007\u00037Y\u0001\u0019\u0001,\t\r\u0005}1\u00021\u0001W\u0001")
public class CloudServiceClient
extends AzureCredentials {
    private final ComputeManager computeManager = ComputeManager.authenticate((TokenCredential)this.credentials(), (AzureProfile)this.profile());

    public ComputeManager computeManager() {
        return this.computeManager;
    }

    public void deleteCloudService(String resourceGroupName, String cloudServiceName) {
        ((ComputeManagementClient)this.computeManager().serviceClient()).getCloudServices().delete(resourceGroupName, cloudServiceName);
    }

    public void updateCloudService(String resourceGroupName, String cloudServiceName, Map<String, String> tags) {
        ((ComputeManagementClient)this.computeManager().serviceClient()).getCloudServices().update(resourceGroupName, cloudServiceName, tags);
    }

    public CloudServiceNetworkProfile createCloudServiceNetworkProfile(String resourceGroupName, String publicIPAddressName, String loadBalancerName, String loadBalancerFrontEndIpName) {
        SubResource subResource = new SubResource().withId(new StringBuilder(78).append("/subscriptions/").append(this.subscriptionId()).append("/resourceGroups/").append(resourceGroupName).append("/providers/Microsoft.Network/publicIPAddresses/").append(publicIPAddressName).toString());
        LoadBalancerFrontendIpConfigurationProperties lBFeIpConfProp = new LoadBalancerFrontendIpConfigurationProperties().withPublicIpAddress(subResource);
        LoadBalancerFrontendIpConfiguration lbFeIpConf = new LoadBalancerFrontendIpConfiguration().withName(loadBalancerFrontEndIpName).withProperties(lBFeIpConfProp);
        LoadBalancerConfigurationProperties lbConfProp = new LoadBalancerConfigurationProperties().withFrontendIpConfigurations(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)lbFeIpConf, (List)Nil$.MODULE$)).asJava());
        LoadBalancerConfiguration lbConf = new LoadBalancerConfiguration().withName(loadBalancerName).withProperties(lbConfProp);
        CloudServiceNetworkProfile cloudServiceNetworkProfile = new CloudServiceNetworkProfile().withLoadBalancerConfigurations(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)lbConf, (List)Nil$.MODULE$)).asJava());
        return cloudServiceNetworkProfile;
    }

    public CloudServiceRoleProfile createCloudServiceRoleProfile(String skuName, int skuCapacity, String skuTier, String roleName) {
        CloudServiceRoleSku cloudServiceRoleSku = new CloudServiceRoleSku().withName(skuName).withCapacity(Predef$.MODULE$.long2Long((long)skuCapacity)).withTier(skuTier);
        CloudServiceRoleProfileProperties cloudServiceRoleProfileProperties = new CloudServiceRoleProfileProperties().withName(roleName).withSku(cloudServiceRoleSku);
        CloudServiceRoleProfile cloudServiceRoleProfile = new CloudServiceRoleProfile().withRoles(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)cloudServiceRoleProfileProperties, (List)Nil$.MODULE$)).asJava());
        return cloudServiceRoleProfile;
    }

    public void createCloudService(String resourceGroupName, String cloudServiceName, String publicIPAddressName, String location, String loadBalancerName, String loadBalancerFrontEndIpName, String configurationUrl, String packageUrl, String skuName, int skuCapacity, String skuTier, String roleName) {
        CloudServiceNetworkProfile cloudServiceNetworkProfile = this.createCloudServiceNetworkProfile(resourceGroupName, publicIPAddressName, loadBalancerName, loadBalancerFrontEndIpName);
        CloudServiceRoleProfile cloudServiceRoleProfile = this.createCloudServiceRoleProfile(skuName, skuCapacity, skuTier, roleName);
        CloudServiceProperties csProp = new CloudServiceProperties().withConfigurationUrl(configurationUrl).withPackageUrl(packageUrl).withRoleProfile(cloudServiceRoleProfile).withNetworkProfile(cloudServiceNetworkProfile);
        CloudServiceInner cloudInner = new CloudServiceInner().withProperties(csProp).withLocation(location);
        ((ComputeManagementClient)this.computeManager().serviceClient()).getCloudServices().createOrUpdate(resourceGroupName, cloudServiceName, cloudInner);
    }

    public CloudServiceClient(ConfigurationItem cloud, ExecutionContext context) {
        super(cloud, context);
    }

    public CloudServiceClient(PyObject pyCloud, ExecutionContext context) {
        this(package$.MODULE$.getAzureCloudFromPyObject(pyCloud), context);
    }
}

