import json
import xml.etree.ElementTree as ET
import requests

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

resource_group_name = rg.resourceGroupName or rg.name
web_app_name = deployed.webAppName
web_job_name = deployed.webJobName or deployed.name


print "Deploying Web Job artifact {0} to Web App {1} under Resource Group {2}".format(web_job_name, web_app_name,  resource_group_name)

# synchronous
credentials = web_client.web_apps.list_publishing_profile_xml_with_secrets(
    resource_group_name=resource_group_name,
    name=web_app_name,
    format='Ftp'
)

#Parse credentials from XML
root = ET.XML(''.join(credentials))
for publishProfile in root:
    if publishProfile.attrib['publishMethod'] == 'MSDeploy':
        api_username = publishProfile.attrib['userName']
        api_password = publishProfile.attrib['userPWD']

api_url="https://" + web_app_name + ".scm.azurewebsites.net/api/" + deployed.jobType + "/" + web_job_name
files =  open(deployed.file.path, 'rb')
headers = { "Content-Type": "application/zip",
            "Content-Disposition": "attachement; filename={0}".format(deployed.executableFileName) }

r = requests.put(
    url=api_url,
    data=files,
    auth=(api_username, api_password),
    headers=headers
)

logger.info("Result: {0}".format(r))

if deployed.jobType == "continuouswebjobs":
    if deployed.isSingleton == True:
        singletonString = "true"
    else:
        singletonString = "false"
    body = json.dumps({"is_singleton": singletonString})

elif deployed.jobType == "triggeredwebjobs":
    if deployed.schedule:
        body = json.dumps({"schedule": deployed.schedule})

api_url="https://" + web_app_name + ".scm.azurewebsites.net/api/" + deployed.jobType + "/" + web_job_name + "/settings"

r = requests.put(
    url=api_url,
    data=body,
    auth=(api_username, api_password),
    headers={ "Content-Type": "application/json" }
)

logger.info("Result: {0}".format(r))
