from azure.mgmt.web.models.application_logs_config import ApplicationLogsConfig
from azure.mgmt.web.models.azure_blob_storage_application_logs_config import AzureBlobStorageApplicationLogsConfig
from azure.mgmt.web.models.file_system_application_logs_config import FileSystemApplicationLogsConfig
from azure.mgmt.web.models.site_logs_config import SiteLogsConfig
from azure.mgmt.web.models.azure_blob_storage_http_logs_config import AzureBlobStorageHttpLogsConfig
from azure.mgmt.web.models.file_system_http_logs_config import FileSystemHttpLogsConfig
from azure.mgmt.web.models.http_logs_config import HttpLogsConfig
from azure.mgmt.web.models.enabled_config import EnabledConfig

from xld.azure.connector import AzureConnector

rg = previousDeployed.container
cloud = rg.container
connector = AzureConnector(cloud)
web_client = connector.web_client()

resource_group_name = rg.resourceGroupName or rg.name
resource_group_location = rg.location
web_app_name = previousDeployed.webAppName

print "Resetting logging for Web App {0} under Resource Group {1}".format(web_app_name, resource_group_name)

# Application logging configuration
application_logs_config = ApplicationLogsConfig()
application_logs_config.file_system = FileSystemApplicationLogsConfig()
application_logs_config.azure_blob_storage = AzureBlobStorageApplicationLogsConfig()

# Web server logging configuration
http_logs_config = HttpLogsConfig()
http_logs_config.file_system = FileSystemHttpLogsConfig()
http_logs_config.azure_blob_storage = AzureBlobStorageHttpLogsConfig()

# Detailed error messages (on/off)
errorMessages = EnabledConfig(False)

# Failed requests tracing (on/off)
failedRequestsTracing = EnabledConfig(False)

site_logs_config = SiteLogsConfig(location=resource_group_location, kind="Site", name=web_app_name, application_logs=application_logs_config, http_logs=http_logs_config, failed_requests_tracing=failedRequestsTracing, detailed_error_messages=errorMessages)

result = web_client.web_apps.update_diagnostic_logs_config(resource_group_name=resource_group_name, name=web_app_name, site_logs_config=site_logs_config)

logger.info("result:  {}", result)

print "Successfully reset web app logging."
