from xld.azure import wait_for_success_provisioning

from msrestazure.azure_exceptions import CloudError
from xld.azure.connector import AzureConnector

rg = previousDeployed.container
cloud = rg.container
connector = AzureConnector(cloud)

compute_client = connector.compute_client()


resource_group_name = rg.resourceGroupName or rg.name
virtual_machine_name = previousDeployed.virtualMachineName or previousDeployed.name

# synchronous
try:
    op_result = compute_client.virtual_machines.get(
        resource_group_name=resource_group_name,
        vm_name=virtual_machine_name,
        expand='instanceview'
    )

    logger.info("VM details: {0}".format(op_result))

    result = wait_for_success_provisioning(op_result, virtual_machine_name)

    logger.info("Result: {0}".format(op_result))

except CloudError as e:
    print e.error.error
    if not (e.error.error in ['ResourceNotFound', 'NotFound']):
        raise
