from azure.mgmt.storage.models import StorageAccountUpdateParameters, Sku, SkuName
from xld.azure import check_persistent_parameters, get_enum_by_value

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
storage_client = connector.storage_client()

storage_account_name = deployed.storageAccountName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

storage_account_parameters = StorageAccountUpdateParameters(
    sku=Sku(get_enum_by_value(deployed.storageAccountType, SkuName).name),
    tags=deployed.storageAccountTags
)

check_persistent_parameters(deployed, previousDeployed, ['storageAccountName', 'name'])

print "Modifying Storage {0} under Resource Group {1}".format(
    storage_account_name,
    resource_group_name)

# synchronous
op_result = storage_client.storage_accounts.update(
    resource_group_name=resource_group_name,
    account_name=storage_account_name,
    parameters=storage_account_parameters
)

logger.info("Result: {0}".format(op_result))
