from azure.mgmt.storage.models import StorageAccountCreateParameters, Sku, SkuName, Kind
from xld.azure import get_enum_by_value

from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)
storage_client = connector.storage_client()

storage_account_name = deployed.storageAccountName or deployed.name
resource_group_name = rg.resourceGroupName or rg.name

storage_account_parameters = StorageAccountCreateParameters(
    sku=Sku(get_enum_by_value(deployed.storageAccountType, SkuName).name),
    kind=get_enum_by_value(deployed.storageAccountKind, Kind).name,
    location=deployed.location,
    tags=deployed.storageAccountTags
)

print "Creating Storage {0} under Resource Group {1}".format(
    storage_account_name, resource_group_name)

# asynchronous
op_result = storage_client.storage_accounts.create(
    resource_group_name=resource_group_name,
    account_name=storage_account_name,
    parameters=storage_account_parameters,
    raw=True
)

logger.info("Issued: {0}".format(op_result.response))
