from xld.azure import string_or_none, object_or_none, boolean_or_none
from azure.mgmt.keyvault.models import AccessPolicyEntry, VaultProperties, Sku, KeyPermissions, SecretPermissions, \
    CertificatePermissions, Permissions, VaultCreateOrUpdateParameters


from xld.azure.connector import AzureConnector

rg = deployed.container
cloud = rg.container
connector = AzureConnector(cloud)

kv_managing_client = connector.keyvault_management_client()
kv_client = connector.keyvault_client()

current_object_id = deployed.objectId

if not current_object_id:
    raise Exception('object id needs to be retrieved')

SECRET_PERMISSIONS_ALL = [perm.value for perm in SecretPermissions]
KEY_PERMISSIONS_ALL = [perm.value for perm in KeyPermissions]
CERTIFICATE_PERMISSIONS_ALL = [
    perm.value for perm in CertificatePermissions]

permissions = Permissions()
permissions.keys = KEY_PERMISSIONS_ALL
permissions.secrets = SECRET_PERMISSIONS_ALL
permissions.certificates = CERTIFICATE_PERMISSIONS_ALL

policy = AccessPolicyEntry(deployed.tenantId, current_object_id, permissions)

vault_params = VaultCreateOrUpdateParameters(
    location=rg.location,
    properties=VaultProperties(
        sku=Sku(name='standard'),
        tenant_id=deployed.tenantId,
        access_policies=[policy],
        enabled_for_deployment=deployed.enabledForDeployment,
        enabled_for_template_deployment=deployed.enabledForTemplateDeployment
    )
)

vault_creation_result = kv_managing_client.vaults.create_or_update(
    resource_group_name=rg.resourceGroupName or rg.name,
    vault_name=deployed.keyVaultName or deployed.name,
    parameters=vault_params
)

# :(
# https://github.com/Azure/azure-sdk-for-python/issues/1172

vault_info = kv_managing_client.vaults.get(
    resource_group_name=rg.resourceGroupName or rg.name,
    vault_name=deployed.keyVaultName or deployed.name
)

for secret in deployed.secrets:

    existing_secret_versions_iter = kv_client.get_secret_versions(
        vault_base_url=vault_info.properties.vault_uri,
        secret_name=secret.secretName,
        maxresults=25
    )

    existing_secret_versions = []
    try:
    #    existing_secret_versions = list(existing_secret_versions_iter) or []
        existing_secret_versions = [secretversion for secretversion in existing_secret_versions_iter]
    except Exception as e:
        existing_secret_versions = []

    print existing_secret_versions

    if len(existing_secret_versions) == 0:
        current_secret = kv_client.set_secret(
            vault_base_url=vault_info.properties.vault_uri,
            secret_name=secret.secretName,
            value=secret.secretValue
        )
    else:
        current_secret = existing_secret_versions[0]
