import base64
import yaml
from xld.azure.arm.resource_mapping.resource_mapper import ResourceMapper

class AKSClusterMapper(ResourceMapper):
    def __init__(self, azure_helper):
        super(AKSClusterMapper, self).__init__(["k8s.Master", "k8s.Namespace"])
        self.azure_helper = azure_helper

    def create_cis(self, resource, resource_group_name, folder):
        if self.types_supported(resource.type()):
            cluster_name = resource.name()
            kube_config = yaml.load(self.azure_helper.getClusterAdminCredentials(resource_group_name, cluster_name))
            cluster_id = folder[:folder.rfind('/')+1] + cluster_name + "-AKSCluster"
            properties = {'isEKS':         False,
                          'skipTLS':       False,
                          'apiServerURL':  kube_config['clusters'][0]['cluster']['server'],
                          'caCert':        base64.b64decode(kube_config['clusters'][0]['cluster']['certificate-authority-data']),
                          'token':         kube_config['users'][0]['user']['token'],
                          'tlsCert' :      base64.b64decode(kube_config['users'][0]['user']['client-certificate-data']),
                          'tlsPrivateKey': base64.b64decode(kube_config['users'][0]['user']['client-key-data'])}
            return [
                super(AKSClusterMapper, self)._create_ci("k8s.Master", cluster_id, properties),
                self.create_namespace(cluster_id, "default")
            ]
        else:
            return None

    def create_namespace(self, cluster_id, name):
        namespace_id = "%s/%s" %(cluster_id, name)
        return super(AKSClusterMapper, self)._create_ci("k8s.Namespace", namespace_id, {'namespaceName': name})
