import json
from com.xebialabs.deployit.plugin.azure import AzureHelper

azure_helper = AzureHelper(deployed.container)

deploymentName = deployed.deploymentName
resourceGroupName = deployed.resourceGroupName

if not deploymentName or not deploymentName.strip():
    raise Exception("Template '%s' must have its 'Deployment Name' set" % deployed.name)

if not azure_helper.resourceGroupExists(resourceGroupName):
    raise Exception("Resource Group '%s' does not exist." % resourceGroupName)

parameters = {}
input_variables = deployed.inputVariables
for k in input_variables:
    parameters[k] = {'value': input_variables[k]}

azure_helper.deployResourceGroupTemplate(resourceGroupName,
                                         deployed.deploymentName,
                                         cf_template,
                                         json.dumps(parameters),
                                         deployed.deploymentMode)
