from com.xebialabs.deployit.plugin.azure import AzureHelper

azure_helper = AzureHelper(deployed.container)

deploymentName = deployed.deploymentName

if not deploymentName or not deploymentName.strip():
    raise Exception("ARM Template '%s' must have its 'Deployment Name' set" % deployed.name)

output = azure_helper.captureDeploymentOutput(deploymentName)
output_variables = {}
if output:
    for k, v in output.items():
        print("Setting output variable '%s' to '%s'" % (k, '%s' % v['value']))
        output_variables[k] = '%s' % v['value']

deployed.outputVariables = output_variables
